/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WindowFunction;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SQLFragmentSXMLGenerator
extends SXMLFragmentGenerator {
    private static Map<String, List<String>> s_elementTypeMap;
    private static Map<Comparison.Comparator, String> s_comparisonMap;
    private static Map<ArithmeticOperation.ArithmeticOperator, String> s_arithOpsMap;
    private static List<String> s_genericXsdTypes;
    private static List<String> s_compoundExpressionGroup;
    private String m_schemaName;
    private boolean m_buildParsedSQL = false;

    public SQLFragmentSXMLGenerator() {
        SQLFragmentSXMLGenerator.buildMaps();
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        if (!(obj instanceof SQLFragment)) {
            this.m_schemaName = this.getSchemaName(obj);
            if (this.getParentGenerator() instanceof SXMLGenerator) {
                this.m_buildParsedSQL = ((SXMLGenerator)this.getParentGenerator()).isBuildParsedSQL();
            }
            if (obj instanceof SQLQueryOwner) {
                this.processSQLQueryOwner(parent, doc, (SQLQueryOwner)obj);
            } else if (obj instanceof Index) {
                this.processIndex(parent, doc, (Index)obj);
            } else if (obj instanceof CheckConstraint) {
                this.processCheckConstraint(parent, doc, (CheckConstraint)obj);
            } else if (!(obj instanceof Constraint)) {
                throw new IllegalArgumentException("SQLFragmentSXMLGenerator called with object of unexpected class: " + obj.getClass().getCanonicalName());
            }
        } else {
            boolean done = this.processSQLFragment(parent, doc, (SQLFragment)obj);
            if (!done) {
                if (obj instanceof SimpleSQLFragment) {
                    done = this.processSimpleSQLFragment(parent, doc, (SimpleSQLFragment)obj);
                } else if (obj instanceof SQLQuery) {
                    done = this.processSQLQuery(parent, doc, (SQLQuery)obj);
                } else if (obj instanceof SelectObject) {
                    done = this.processSelectObject(parent, doc, (SelectObject)obj);
                } else if (obj instanceof FromObject) {
                    done = this.processFromObject(parent, doc, (FromObject)obj);
                } else if (obj instanceof WhereObject) {
                    done = this.processWhereObject(parent, doc, (WhereObject)obj);
                } else if (obj instanceof RelationUsage) {
                    done = this.processRelationUsage(parent, doc, (RelationUsage)obj);
                } else if (obj instanceof JoinObject) {
                    done = this.processJoinObject(parent, doc, (JoinObject)obj);
                } else if (obj instanceof AbstractFromObjectUsage) {
                    done = this.processAbstractFromObjectUsage(parent, doc, (AbstractFromObjectUsage)obj);
                } else if (obj instanceof WindowFunction) {
                    done = this.processWindowFunction(parent, doc, (WindowFunction)obj);
                } else if (obj instanceof WindowFunction.WindowFunctionBound) {
                    done = this.processWindowFunctionBound(parent, doc, (WindowFunction.WindowFunctionBound)obj);
                } else if (obj instanceof Function) {
                    done = this.processFunction(parent, doc, (Function)obj);
                } else if (obj instanceof FunctionUsage) {
                    done = this.processFunctionUsage(parent, doc, (FunctionUsage)obj);
                } else if (obj instanceof OrderByObject) {
                    done = this.processOrderByObject(parent, doc, (OrderByObject)obj);
                } else if (obj instanceof SetOperation) {
                    done = this.processSetOperation(parent, doc, (SetOperation)obj);
                } else if (obj instanceof ExpressionList) {
                    done = this.processExpressionList(parent, doc, (ExpressionList)obj);
                } else if (obj instanceof GroupByExpression) {
                    done = this.processGroupByExpression(parent, doc, (GroupByExpression)obj);
                } else if (obj instanceof CaseStatement) {
                    done = this.processCaseStatement(parent, doc, (CaseStatement)obj);
                } else if (obj instanceof CaseStatement.WhenThen) {
                    done = this.processCaseStatementWhenThen(parent, doc, (CaseStatement.WhenThen)obj);
                } else if (obj instanceof DataMiningFunction) {
                    throw new UnsupportedTypeForSXMLException("No support for DataMiningFunction yet...");
                }
            }
            if (!done) {
                throw new UnsupportedTypeForSXMLException(((SQLFragment)obj).getSQLText() + " not supported (" + obj.getClass().getCanonicalName() + ")");
            }
        }
    }

    private void processSQLQueryOwner(Node parent, Document doc, SQLQueryOwner vw) {
        SQLQuery query = vw.getSQLQuery();
        if (query != null) {
            Node queryTextNode = null;
            if (this.m_buildParsedSQL && query.isDeclarative()) {
                Node parsedQueryNode = this.findOrCreateNodeBefore(doc, parent, "PARSED_SUBQUERY", "CUSTOMER_AREA");
                try {
                    this.populateNode(parsedQueryNode, doc, query);
                    Node customerPropList = this.findOrCreateNode(doc, parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                    queryTextNode = this.createNode(doc, customerPropList, "SUBQUERY");
                }
                catch (UnsupportedTypeForSXMLException e) {
                    parent.removeChild(parsedQueryNode);
                }
            }
            if (queryTextNode == null) {
                queryTextNode = this.findOrCreateNodeBefore(doc, parent, "SUBQUERY", "CUSTOMER_AREA");
            }
            queryTextNode.appendChild(doc.createTextNode(query.getSQLText()));
        }
    }

    private void processIndex(Node parent, Document doc, Index idx) {
        Node colListItemNode;
        Node tableIndexNode = this.findOrCreateNodeAfter(doc, parent, "TABLE_INDEX", "NAME");
        Node colListNode = this.findOrCreateNodeAfter(doc, tableIndexNode, "COL_LIST", "ON_TABLE");
        Node sqlTextNode = null;
        if (this.m_buildParsedSQL) {
            try {
                for (IndexObject io : idx.getColumnExpressions()) {
                    colListItemNode = this.createNode(doc, colListNode, "COL_LIST_ITEM");
                    this.processMapping(colListItemNode, doc, (SQLFragment)io, "COLUMN_EXPRESSION", "expression");
                    this.processMapping(colListItemNode, doc, (SQLFragment)io, "DESC", "order", new ValueCheckingConverter("DESC"));
                }
                Node customerPropList = this.findOrCreateNode(doc, parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                sqlTextNode = this.createNode(doc, customerPropList, "COL_LIST");
            }
            catch (UnsupportedTypeForSXMLException e) {
                parent.removeChild(tableIndexNode);
                sqlTextNode = this.findOrCreateNodeAfter(doc, tableIndexNode, "COL_LIST", "ON_TABLE");
            }
        } else {
            sqlTextNode = colListNode;
        }
        for (IndexObject io : idx.getColumnExpressions()) {
            colListItemNode = this.createNode(doc, sqlTextNode, "COL_LIST_ITEM");
            Node nameNode = this.createNode(doc, colListItemNode, "NAME");
            String exp = io.getExpressionSource();
            SQLFragment frag = io.getExpression();
            if (!(frag == null || frag instanceof ColumnUsage && io.getOrderType() != IndexObject.OrderType.DESC)) {
                frag = (SQLFragment)frag.copyTo(null);
                this.markColumnUsages(frag);
                exp = frag.getSQLText();
            }
            nameNode.appendChild(doc.createTextNode(exp));
            this.processMapping(colListItemNode, doc, (SQLFragment)io, "DESC", "order", new ValueCheckingConverter("DESC"));
        }
    }

    private void processCheckConstraint(Node parent, Document doc, CheckConstraint cc) {
        SQLFragment frag;
        Node sqlTextNode = null;
        if (this.m_buildParsedSQL && !((frag = cc.getCheckConditionFragment()) instanceof SimpleSQLFragment)) {
            Node parsedQueryNode = this.findOrCreateNodeAfter(doc, parent, "PARSED_CONDITION", "NAME");
            try {
                this.populateNode(parsedQueryNode, doc, frag);
                Node customerPropList = this.findOrCreateNode(doc, parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                sqlTextNode = this.createNode(doc, customerPropList, "CONDITION");
            }
            catch (UnsupportedTypeForSXMLException e) {
                parent.removeChild(parsedQueryNode);
            }
        }
        if (sqlTextNode == null) {
            sqlTextNode = this.findOrCreateNodeAfter(doc, parent, "CONDITION", "NAME");
        }
        sqlTextNode.appendChild(doc.createTextNode(cc.getCheckCondition()));
    }

    private boolean processSQLFragment(Node parent, Document doc, SQLFragment frag) {
        boolean canDo = false;
        String elementName = this.getElementName(frag);
        if (s_elementTypeMap.containsKey(elementName)) {
            canDo = true;
            for (String type : s_elementTypeMap.get(elementName)) {
                if (s_genericXsdTypes.contains(type)) continue;
                canDo = false;
                break;
            }
        }
        if (canDo) {
            Node elementNode = this.createNode(doc, parent, elementName);
            for (DBObject child : frag.getOwnedObjects(new String[]{"SQLFragment"})) {
                this.populateNode(elementNode, doc, child);
            }
        }
        return canDo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processSimpleSQLFragment(Node parent, Document doc, SimpleSQLFragment frag) {
        String sqlText = frag.getSQLText();
        if (frag.getParent() instanceof Function && "TRANSLATE".equals(((Function)frag.getParent()).getFunction()) && !",".equals(((Function)frag.getParent()).getSeparator().trim())) {
            this.processMapping(parent, doc, (SQLFragment)frag, "USING_CS", "SQLText");
            return true;
        }
        if (sqlText != null && (frag.getParent() instanceof SelectObject || frag.getParent() instanceof Operation || frag.getParent() instanceof OrderByObject)) {
            Node node = null;
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)(sqlText = sqlText.trim()), (String[])new String[0]);
            if (((PlSqlToken)tk.getNextCodeToken()).getType() == Token.Type.END_MARKER && tk.getType() == Token.Type.SINGLE_QUOTED_STRING) {
                node = this.createNode(doc, parent, "STRING");
                sqlText = sqlText.substring(1, sqlText.length() - 1);
                sqlText = sqlText.replaceAll("''", "'");
            } else {
                try {
                    Float f = new Float(sqlText);
                    node = this.createNode(doc, parent, "LITERAL");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (node == null) return false;
            node.appendChild(doc.createTextNode(sqlText));
            return true;
        }
        if (!(frag.getParent() instanceof FromObject) || !sqlText.toUpperCase().equals("DUAL")) return false;
        Node node = this.createNode(doc, parent, "TABLE");
        node.appendChild(doc.createTextNode("DUAL"));
        return true;
    }

    private boolean processSQLQuery(Node parent, Document doc, SQLQuery frag) {
        Node queryNode = this.createNode(doc, parent, "QUERY");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "SELECT/SELECT_LIST//SELECT_LIST_ITEM", "selectObjects");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "FROM//FROM_ITEM", "fromObjects");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "WHERE", "whereObject");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "GROUP_BY/EXPRESSION_LIST//EXPRESSION_LIST_ITEM", "groupByObject/expressions");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "HAVING", "groupByObject/having");
        this.processMapping(queryNode, doc, (SQLFragment)frag, "ORDER_BY/ORDER_BY_LIST//ORDER_BY_LIST_ITEM", "orderByObjects/expression");
        return true;
    }

    private boolean processSelectObject(Node parent, Document doc, SelectObject frag) {
        this.processMapping(parent, doc, (SQLFragment)frag, "", "expression");
        this.processMapping(parent, doc, (SQLFragment)frag, "COLUMN_ALIAS", "alias", new InternaliseAliasConverter());
        return true;
    }

    private boolean processFromObject(Node parent, Document doc, FromObject frag) {
        this.processMapping(parent, doc, (SQLFragment)frag, "", "expression");
        this.processMapping(parent, doc, (SQLFragment)frag, "TABLE_ALIAS", "alias", new InternaliseAliasConverter());
        return true;
    }

    private boolean processWhereObject(Node parent, Document doc, WhereObject frag) {
        Node node = parent;
        if (frag instanceof OnJoinCondition) {
            node = this.createNode(doc, node, "ON");
        }
        if (frag.getArgumentCount() != 1) {
            node = this.createNode(doc, node, frag.getOperatorText());
        }
        this.processMapping(node, doc, (SQLFragment)frag, "//", "arguments");
        return true;
    }

    private boolean processRelationUsage(Node parent, Document doc, RelationUsage frag) {
        this.processMapping(parent, doc, (SQLFragment)frag, "SCHEMA", "objectID/schema/name", new OnlyIfDifferentConverter(this.m_schemaName));
        this.processMapping(parent, doc, (SQLFragment)frag, "TABLE", "objectID/name");
        return true;
    }

    private boolean processJoinObject(Node parent, Document doc, JoinObject frag) {
        Node joinNode = this.createNode(doc, parent, "JOIN");
        if (frag.isNatural() && !frag.isOuterJoin()) {
            this.processMapping(joinNode, doc, (SQLFragment)frag, "NATURAL_INNER", "joinType", new ValueCheckingConverter("INNER"));
        } else {
            if (frag.isNatural() && !frag.isOuterJoin()) {
                this.processMapping(joinNode, doc, (SQLFragment)frag, "NATURAL", "natural");
            }
            this.processMapping(joinNode, doc, (SQLFragment)frag, "INNER", "joinType", new ValueCheckingConverter("INNER"));
            this.processMapping(joinNode, doc, (SQLFragment)frag, "CROSS", "joinType", new ValueCheckingConverter("CROSS"));
            this.processMapping(joinNode, doc, (SQLFragment)frag, "LEFT_OUTER_JOIN", "joinType", new ValueCheckingConverter("LEFT"));
            this.processMapping(joinNode, doc, (SQLFragment)frag, "FULL_OUTER_JOIN", "joinType", new ValueCheckingConverter("FULL"));
            this.processMapping(joinNode, doc, (SQLFragment)frag, "RIGHT_OUTER_JOIN", "joinType", new ValueCheckingConverter("RIGHT"));
        }
        this.processMapping(joinNode, doc, (SQLFragment)frag, "JOIN_TABLE_1", "leftExpression");
        this.processMapping(joinNode, doc, (SQLFragment)frag, "JOIN_TABLE_2", "rightExpression");
        if ("INNER".equals(frag.getJoinType()) && !frag.isNatural() || frag.isOuterJoin()) {
            if (frag.getCondition() instanceof OnJoinCondition) {
                this.processMapping(joinNode, doc, (SQLFragment)frag, "", "condition");
            } else if (frag.getCondition() instanceof UsingJoinCondition) {
                this.processMapping(joinNode, doc, (SQLFragment)frag, "USING//COLUMN", "condition/columns/objectID/name");
            }
        }
        return true;
    }

    private boolean processAbstractFromObjectUsage(Node parent, Document doc, AbstractFromObjectUsage frag) {
        Node colRefNode = this.createNode(doc, parent, "COLUMN_REF");
        this.processMapping(colRefNode, doc, (SQLFragment)frag, "SCHEMA", "objectID/parent/schemaName", new OnlyIfDifferentConverter(this.m_schemaName));
        this.processMapping(colRefNode, doc, (SQLFragment)frag, "TABLE", "objectID/parent/name");
        if (frag instanceof SelectObjectUsage) {
            SelectObjectUsage sou = (SelectObjectUsage)frag;
            SelectObject so = sou.resolveSelectObject();
            if (so != null) {
                this.processMapping(colRefNode, doc, (SQLFragment)so, "COLUMN", "name", new InternaliseAliasConverter());
            } else if (sou.getSelectObjectID() instanceof BaseObjectID) {
                String name = ((BaseObjectID)sou.getSelectObjectID()).getName();
                Node n = this.createNode(doc, colRefNode, "COLUMN");
                n.appendChild(doc.createTextNode(name));
            }
        } else {
            this.processMapping(colRefNode, doc, (SQLFragment)frag, "COLUMN", "columnName");
        }
        this.processMapping(colRefNode, doc, (SQLFragment)frag, "OUTER_JOIN_OP", "objectID/outerJoin");
        return true;
    }

    private boolean processOrderByObject(Node parent, Document doc, OrderByObject frag) {
        Node orderNode = parent;
        if ("ASC".equals(frag.getOrder()) && "NULLS FIRST".equals(frag.getNullOrdering())) {
            orderNode = this.createNode(doc, parent, "ASC_NULLS_FIRST");
        } else if ("DESC".equals(frag.getOrder()) && "NULLS LAST".equals(frag.getNullOrdering())) {
            orderNode = this.createNode(doc, parent, "DESC_NULLS_LAST");
        } else if ("DESC".equals(frag.getOrder())) {
            orderNode = this.createNode(doc, parent, "DESC");
        }
        this.populateNode(orderNode, doc, frag.getExpression());
        return true;
    }

    private boolean processSetOperation(Node parent, Document doc, SetOperation frag) {
        block14: {
            SetOperation.Operator op;
            block12: {
                block13: {
                    op = frag.getOperator();
                    if (frag.getArgumentCount() != 2 || !(frag.getArguments()[1] instanceof SQLQuery)) break block12;
                    if (op != SetOperation.Operator.IN) break block13;
                    Node eqNode = this.createNode(doc, parent, "EQ");
                    this.populateNode(eqNode, doc, frag.getArguments()[0]);
                    Node anyNode = this.createNode(doc, eqNode, "ANY");
                    this.populateNode(anyNode, doc, frag.getArguments()[1]);
                    break block14;
                }
                if (op != SetOperation.Operator.NOT_IN) break block14;
                Node neNode = this.createNode(doc, parent, "NE");
                this.populateNode(neNode, doc, frag.getArguments()[0]);
                Node allNode = this.createNode(doc, neNode, "ALL");
                this.populateNode(allNode, doc, frag.getArguments()[1]);
                break block14;
            }
            if (op == SetOperation.Operator.IN) {
                Node orNode = this.createNode(doc, parent, "OR");
                for (int i = 1; i < frag.getArgumentCount(); ++i) {
                    Node eqNode = this.createNode(doc, orNode, "EQ");
                    this.populateNode(eqNode, doc, frag.getArguments()[0]);
                    this.populateNode(eqNode, doc, frag.getArguments()[i]);
                }
            } else if (op == SetOperation.Operator.NOT_IN) {
                Node andNode = this.createNode(doc, parent, "AND");
                for (int i = 1; i < frag.getArgumentCount(); ++i) {
                    Node neNode = this.createNode(doc, andNode, "NE");
                    this.populateNode(neNode, doc, frag.getArguments()[0]);
                    this.populateNode(neNode, doc, frag.getArguments()[i]);
                }
            } else if (op == SetOperation.Operator.BETWEEN) {
                Node andNode = this.createNode(doc, parent, "AND");
                Node geNode = this.createNode(doc, andNode, "GE");
                this.populateNode(geNode, doc, frag.getArguments()[0]);
                this.populateNode(geNode, doc, frag.getArguments()[1]);
                Node leNode = this.createNode(doc, andNode, "LE");
                this.populateNode(leNode, doc, frag.getArguments()[0]);
                this.populateNode(leNode, doc, frag.getArguments()[2]);
            } else if (op == SetOperation.Operator.NOT_BETWEEN) {
                Node orNode = this.createNode(doc, parent, "OR");
                Node ltNode = this.createNode(doc, orNode, "LT");
                this.populateNode(ltNode, doc, frag.getArguments()[0]);
                this.populateNode(ltNode, doc, frag.getArguments()[1]);
                Node gtNode = this.createNode(doc, orNode, "GT");
                this.populateNode(gtNode, doc, frag.getArguments()[0]);
                this.populateNode(gtNode, doc, frag.getArguments()[2]);
            } else if (op == SetOperation.Operator.EQUALS_ANY) {
                Node orNode = this.createNode(doc, parent, "OR");
                for (int i = 1; i < frag.getArgumentCount(); ++i) {
                    Node eqNode = this.createNode(doc, orNode, "EQ");
                    this.populateNode(eqNode, doc, frag.getArguments()[0]);
                    this.populateNode(eqNode, doc, frag.getArguments()[i]);
                }
            }
        }
        return true;
    }

    private boolean processCaseStatement(Node parent, Document doc, CaseStatement frag) {
        Node caseNode = this.createNode(doc, parent, "CASE");
        this.processMapping(caseNode, doc, (SQLFragment)frag, "//WHEN", "whenThens");
        this.processMapping(caseNode, doc, (SQLFragment)frag, "ELSE", "elseExpression");
        return true;
    }

    private boolean processCaseStatementWhenThen(Node parent, Document doc, CaseStatement.WhenThen frag) {
        this.processMapping(parent, doc, (SQLFragment)frag, "", "whenExpression");
        this.processMapping(parent, doc, (SQLFragment)frag, "THEN", "thenExpression");
        return true;
    }

    private boolean processExpressionList(Node parent, Document doc, ExpressionList frag) {
        Node exprListNode = this.createNode(doc, parent, "EXPRESSION_LIST");
        this.processMapping(exprListNode, doc, (SQLFragment)frag, "//EXPRESSION_LIST_ITEM", "arguments");
        return true;
    }

    private boolean processFunction(Node parent, Document doc, Function frag) {
        boolean done = false;
        if ("COUNT".equals(frag.getFunction())) {
            Node countNode = this.createNode(doc, parent, "COUNT");
            if (frag.isDistinct()) {
                countNode = this.createNode(doc, countNode, "DISTINCT");
            }
            boolean skip = false;
            if (frag.getArgumentCount() == 1 && frag.getArguments()[0] instanceof ColumnKeywordUsage && "*".equals(((ColumnKeywordUsage)frag.getArguments()[0]).getColumnName())) {
                skip = true;
            }
            if (!skip) {
                this.processMapping(countNode, doc, (SQLFragment)frag, "//", "arguments");
            }
            done = true;
        } else if ("CAST".equals(frag.getFunction())) {
            Node castNode = this.createNode(doc, parent, "CAST");
            this.populateNode(castNode, doc, frag.getArguments()[0]);
            Node asTypeNode = this.createNode(doc, castNode, "AS_TYPE");
            DataTypeSXMLGenerator dtgen = new DataTypeSXMLGenerator();
            dtgen.setParentGenerator(this.getParentGenerator());
            dtgen.populateNode(asTypeNode, doc, frag.getArguments()[1]);
            done = true;
        } else if ("TRIM".equals(frag.getFunction())) {
            String fname = "TRIM";
            if (frag.getTrimLeader() != null) {
                if (frag.getTrimLeader().trim().startsWith("LEADING")) {
                    fname = "LTRIM";
                } else if (frag.getTrimLeader().trim().startsWith("TRAILING")) {
                    fname = "RTRIM";
                }
            }
            Node trimNode = this.createNode(doc, parent, fname);
            for (int i = frag.getArgumentCount(); i > 0; --i) {
                this.populateNode(trimNode, doc, frag.getArguments()[i - 1]);
            }
            done = true;
        }
        return done;
    }

    private boolean processFunctionUsage(Node parent, Document doc, FunctionUsage frag) {
        DBObjectID fuid = frag.getObjectID();
        if (fuid instanceof BaseObjectID) {
            BaseObjectID id = (BaseObjectID)fuid;
            String schemaName = id.getSchemaName();
            String parentType = null;
            String parentName = null;
            if (id.getParent() instanceof BaseObjectID) {
                BaseObjectID pid = (BaseObjectID)id.getParent();
                schemaName = pid.getSchemaName();
                parentType = pid.getType();
                parentName = pid.getName();
            }
            Node functionExprNode = this.createNode(doc, parent, "FUNCTION_EXPR");
            Node functionRefNode = this.createNode(doc, functionExprNode, "FUNCTION_REF");
            if (schemaName != null && !schemaName.equals(this.m_schemaName)) {
                Node schemaNode = this.createNode(doc, functionRefNode, "SCHEMA");
                schemaNode.appendChild(doc.createTextNode(schemaName));
            }
            if (parentType != null && !"UNSPECIFIED_TYPE".equals(parentType)) {
                Node typeNode = this.createNode(doc, functionRefNode, parentType);
                typeNode.appendChild(doc.createTextNode(parentName));
            }
            this.processMapping(functionRefNode, doc, (SQLFragment)frag, "FUNCTION", "objectID/name");
            this.processMapping(functionExprNode, doc, (SQLFragment)frag, "ARG_LIST//ARG_LIST_ITEM", "arguments");
        }
        return true;
    }

    private boolean processGroupByExpression(Node parent, Document doc, GroupByExpression frag) {
        Node groupByTypeNode = this.createNode(doc, parent, frag.getGroupByType().toString());
        this.processMapping(groupByTypeNode, doc, (SQLFragment)frag, "EXPRESSION_LIST//EXPRESSION_LIST_ITEM", "arguments");
        return true;
    }

    private boolean processWindowFunction(Node parent, Document doc, WindowFunction frag) {
        String elementName = frag.getFunction();
        if ("COUNT".equals(elementName)) {
            this.processFunction(parent, doc, (Function)frag);
        } else {
            Node elementNode = this.createNode(doc, parent, elementName);
            for (SQLFragment child : frag.getArguments()) {
                this.populateNode(elementNode, doc, child);
            }
        }
        this.processMapping(parent, doc, (SQLFragment)frag, elementName + "/OVER/PARTITION_BY//PARTITION_BY_ITEM", "partitionBy");
        this.processMapping(parent, doc, (SQLFragment)frag, elementName + "/OVER/ORDER_BY/ORDER_BY_LIST//ORDER_BY_LIST_ITEM", "orderBy");
        String clauseType = "RANGE";
        if (frag.getClauseType() == WindowFunction.ClauseType.ROWS) {
            clauseType = "ROWS";
        }
        SQLFragment[] origBounds = frag.getBounds();
        SQLFragment[] newBounds = null;
        if (origBounds != null && origBounds.length == 1) {
            newBounds = new SQLFragment[2];
            newBounds[0] = (SQLFragment)origBounds[0].copyTo(null);
            WindowFunction.WindowFunctionBound currRow = new WindowFunction.WindowFunctionBound();
            currRow.setBoundType(WindowFunction.BoundType.CURRENT_ROW);
            newBounds[1] = currRow;
            frag.setBounds(newBounds);
        }
        this.processMapping(parent, doc, (SQLFragment)frag, elementName + "/OVER/ORDER_BY/" + clauseType + "/BETWEEN//BETWEEN_ITEM", "bounds");
        if (newBounds != null) {
            frag.setBounds(origBounds);
        }
        return true;
    }

    private boolean processWindowFunctionBound(Node parent, Document doc, WindowFunction.WindowFunctionBound frag) {
        if (frag.getBoundExpr() == null || frag.getBoundExpr().length == 0) {
            if (!"CURRENT_ROW".equals(frag.getBoundType().toString())) {
                this.createNode(doc, parent, "UNBOUNDED");
            }
        } else {
            this.processMapping(parent, doc, (SQLFragment)frag, "//", "boundExpr");
        }
        this.createNode(doc, parent, frag.getBoundType().toString());
        return true;
    }

    private String getElementName(SQLFragment frag) {
        ArithmeticOperation arithOp;
        String elementName = null;
        if (frag instanceof Function && !(frag instanceof WindowFunction)) {
            elementName = ((Function)frag).getFunction();
            if ("TABLE".equals(elementName)) {
                elementName = "TABLE_FUNCTION";
            } else if ("TRIM".equals(elementName)) {
                elementName = null;
            } else if ("||".equals(elementName)) {
                elementName = "CONCAT";
            }
        } else if (frag instanceof Comparison) {
            Comparison comp = (Comparison)frag;
            elementName = s_comparisonMap.get(comp.getComparator());
            if (elementName == null && (elementName = comp.getOperatorText()).contains(" ")) {
                elementName = elementName.replaceAll(" ", "_");
            }
        } else if (frag instanceof ArithmeticOperation && (elementName = s_arithOpsMap.get((arithOp = (ArithmeticOperation)frag).getOperator())) == null && (elementName = arithOp.getOperatorText()).contains(" ")) {
            elementName = elementName.replaceAll(" ", "_");
        }
        return elementName;
    }

    private static synchronized void buildMaps() {
        if (s_elementTypeMap == null) {
            DOMParser parser = new DOMParser();
            String res = SQLFragmentSXMLGenerator.class.getPackage().getName().replaceAll("\\.", "/") + "/xsd/kusparse.xsd";
            URL url = SQLFragmentSXMLGenerator.class.getClassLoader().getResource(res);
            try {
                parser.parse(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
            XMLDocument doc = parser.getDocument();
            Element n = doc.getDocumentElement();
            s_elementTypeMap = new HashMap<String, List<String>>();
            s_compoundExpressionGroup = new ArrayList<String>();
            SQLFragmentSXMLGenerator.addElementsToTypeMap(n);
            s_comparisonMap = new HashMap<Comparison.Comparator, String>();
            s_comparisonMap.put(Comparison.Comparator.EQUAL, "EQ");
            s_comparisonMap.put(Comparison.Comparator.LESS, "LT");
            s_comparisonMap.put(Comparison.Comparator.GREATER, "GT");
            s_comparisonMap.put(Comparison.Comparator.GREATER_EQUAL, "GE");
            s_comparisonMap.put(Comparison.Comparator.LESS_EQUAL, "LE");
            s_comparisonMap.put(Comparison.Comparator.NOT_EQUAL, "NE");
            s_arithOpsMap = new HashMap<ArithmeticOperation.ArithmeticOperator, String>();
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.NEGATE, "NEG");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.ADD, "ADD");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.SUBTRACT, "SUB");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.MULTIPLY, "MUL");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.DIVIDE, "DIV");
            s_genericXsdTypes = new ArrayList<String>();
            s_genericXsdTypes.add("NONE");
            s_genericXsdTypes.add("ku:EmptyType");
            s_genericXsdTypes.add("ku:intElementWithValue1");
            s_genericXsdTypes.add("ku:PrsUnaryExprOpType");
            s_genericXsdTypes.add("ku:PrsBinaryExprOpType");
            s_genericXsdTypes.add("ku:PrsNAryExprOpType");
            s_genericXsdTypes.add("ku:PrsUnaryLogicalOpType");
            s_genericXsdTypes.add("ku:PrsAnaryLogicalOpType");
            s_genericXsdTypes.add("ku:PrsBinaryOpType");
            s_genericXsdTypes.add("ku:PrsLikeOpType");
            s_genericXsdTypes.add("ku:PrsExpressionType");
            s_genericXsdTypes.add("ku:PrsColExpressionType");
            s_genericXsdTypes.add("ku:PrsROLLUPType");
            s_genericXsdTypes.add("ku:PrsTRANSLATEType");
            s_genericXsdTypes.add("ku:PrsAVGType");
        }
    }

    private static void addElementsToTypeMap(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if ("xsd:element".equals(child.getNodeName())) {
                Node typeAttrNode;
                String name = null;
                String type = null;
                Node nameAttrNode = child.getAttributes().getNamedItem("name");
                if (nameAttrNode != null) {
                    name = nameAttrNode.getTextContent();
                }
                type = (typeAttrNode = child.getAttributes().getNamedItem("type")) != null ? typeAttrNode.getTextContent() : "NONE";
                if (name != null) {
                    List<String> typeList = s_elementTypeMap.get(name);
                    if (typeList == null) {
                        typeList = new ArrayList<String>();
                        s_elementTypeMap.put(name, typeList);
                    }
                    if (!typeList.contains(type)) {
                        typeList.add(type);
                    }
                    if (SQLFragmentSXMLGenerator.isNodeInCompoundExpressionGroup(child)) {
                        s_compoundExpressionGroup.add(name);
                    }
                }
            }
            SQLFragmentSXMLGenerator.addElementsToTypeMap(child);
        }
    }

    private static boolean isNodeInCompoundExpressionGroup(Node node) {
        Node gpar;
        Node par = node.getParentNode();
        if (par != null && (gpar = par.getParentNode()) != null) {
            String name = null;
            Node nameAttrNode = gpar.getAttributes().getNamedItem("name");
            if (nameAttrNode != null && "PrsCompoundExpressionGroup".equals(name = nameAttrNode.getTextContent())) {
                return true;
            }
        }
        return false;
    }

    private void processMapping(Node objNode, Document doc, SQLFragment frag, String elemPath, String propPath) {
        this.processMapping(objNode, doc, frag, elemPath, propPath, null);
    }

    private void processMapping(Node objNode, Document doc, SQLFragment frag, String elemPath, String propPath, SXMLValueConverter con) {
        SXMLMappings.Mapping m = new SXMLMappings.Mapping(elemPath, propPath, con);
        this.processPropertyMapping(objNode, doc, frag, m);
    }

    private String getSchemaName(Object obj) {
        if (obj instanceof DBObject) {
            SchemaObject so;
            DBObject o;
            for (o = (DBObject)obj; o != null && !(o instanceof SchemaObject); o = o.getParent()) {
            }
            if (o instanceof SchemaObject && (so = (SchemaObject)o).getSchema() != null) {
                return so.getSchema().getName();
            }
        }
        return null;
    }

    private void markColumnUsages(SQLFragment expr) {
        if (expr instanceof ColumnUsage) {
            ((ColumnUsage)expr).setAlwaysQuote(true);
        }
        for (DBObject kid : expr.getOwnedObjects()) {
            if (!(kid instanceof SQLFragment)) continue;
            this.markColumnUsages((SQLFragment)kid);
        }
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        if (obj instanceof SQLQueryOwner) {
            String queryText;
            SQLQueryOwner sqo = (SQLQueryOwner)obj;
            Node queryParent = parent;
            if (this.nodeExists(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/SUBQUERY")) {
                queryParent = this.findNode(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
            }
            if ((queryText = this.nodeText(queryParent, "SUBQUERY")) != null && queryText.length() > 0) {
                if (obj instanceof View) {
                    if (queryText.trim().endsWith("WITH READ ONLY")) {
                        queryText = queryText.substring(0, queryText.lastIndexOf("WITH READ ONLY")).trim();
                        ((View)obj).setRestriction(View.Restriction.READ_ONLY);
                    } else if (queryText.trim().endsWith("WITH CHECK OPTION")) {
                        queryText = queryText.substring(0, queryText.lastIndexOf("WITH CHECK OPTION")).trim();
                        ((View)obj).setRestriction(View.Restriction.CHECK_OPTION);
                    }
                }
                sqo.setSQLQuery(new SQLQuery(queryText));
            }
        } else if (obj instanceof CheckConstraint) {
            CheckConstraint cc = (CheckConstraint)obj;
            Node conditionParent = parent;
            if (this.nodeExists(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/CONDITION")) {
                conditionParent = this.findNode(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
            }
            cc.setCheckCondition(this.nodeText(conditionParent, "CONDITION"));
        } else if (obj instanceof Index) {
            SXMLReader reader = (SXMLReader)this.getParentGenerator();
            Index idx = (Index)obj;
            ArrayList<IndexObject> ios = new ArrayList<IndexObject>();
            Node colListNode = this.findNode(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COL_LIST");
            if (colListNode == null) {
                colListNode = this.findNode(parent, "TABLE_INDEX/COL_LIST");
            }
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
            while (it.hasNext()) {
                Node colNode = (Node)it.next();
                IndexObject io = new IndexObject();
                String expression = this.nodeText(colNode, "NAME");
                io.setExpressionSource(expression);
                if (this.nodeExists(colNode, "DESC")) {
                    io.setOrderType(IndexObject.OrderType.DESC);
                }
                ios.add(io);
            }
            idx.setColumnExpressions(ios.toArray(new IndexObject[ios.size()]));
        }
    }

    public static final boolean isInCompoundExpressionGroup(String functionName) {
        SQLFragmentSXMLGenerator.buildMaps();
        return s_compoundExpressionGroup.contains(functionName);
    }

    class InternaliseAliasConverter
    implements SXMLValueConverter {
        InternaliseAliasConverter() {
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (propValue instanceof String) {
                String str = ((String)propValue).trim();
                if (str.startsWith("\"") && str.endsWith("\"")) {
                    return str.substring(1, str.length() - 1);
                }
                return str.toUpperCase();
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return null;
        }
    }

    class OnlyIfDifferentConverter
    implements SXMLValueConverter {
        private Object m_value;

        OnlyIfDifferentConverter(Object value) {
            this.m_value = value;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            if (ModelUtil.areEqual((Object)propValue, (Object)this.m_value)) {
                return null;
            }
            return propValue;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            return null;
        }
    }

    class ValueCheckingConverter
    implements SXMLValueConverter {
        private Object[] m_values;

        ValueCheckingConverter(Object ... values) {
            this.m_values = values;
        }

        @Override
        public Object getXMLValue(Object owner, Object propValue) {
            for (Object o : this.m_values) {
                if (!ModelUtil.areEqual((Object)propValue, (Object)o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getBeanValue(Object owner, Object propValue) {
            if (propValue instanceof Boolean) {
                return (Boolean)propValue != false ? this.m_values[0] : null;
            }
            return this.m_values[0];
        }
    }
}

