/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PhysicalPropsSXMLGenerator
extends SXMLFragmentGenerator {
    PhysicalPropsSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        OracleInMemoryProperties imp;
        Table tab = (Table)obj;
        Table.TableType type = (Table.TableType)tab.getProperty("TableType");
        switch (type) {
            case INDEX_ORGANIZED: {
                OracleIndexOrganizedTableProperties iotProps;
                Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
                Node iotNode = this.findOrCreateNode(doc, physicalPropsNode, "INDEX_ORGANIZED_TABLE");
                OracleStorageProperties sProps = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (sProps != null) {
                    Node storageNode = this.findOrCreateNode(doc, iotNode, "SEGMENT_ATTRIBUTES");
                    this.getParentGenerator().populateNode(storageNode, doc, sProps);
                }
                if ((iotProps = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties")) == null) break;
                this.getParentGenerator().populateNode(iotNode, doc, iotProps);
                if (iotProps.isOverflowable()) {
                    this.findOrCreateNodeAfter(doc, iotNode, "OVERFLOW", "KEYCOMPRESS");
                }
                if (!Integer.valueOf(0).equals(iotProps.getKeyCompression())) break;
                Node keyCompressionNode = this.findOrCreateNode(doc, parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/IOT_KEYCOMPRESS");
                keyCompressionNode.appendChild(doc.createTextNode("0"));
                break;
            }
            case EXTERNAL: {
                Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
                Node extNode = this.findOrCreateNode(doc, physicalPropsNode, "EXTERNAL_TABLE");
                OracleExternalTableProperties extProps = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
                if (extProps == null) break;
                this.getParentGenerator().populateNode(extNode, doc, extProps);
                break;
            }
            case TRANSACTION_TEMP: 
            case SESSION_TEMP: {
                String tspaceName;
                DBObjectID tspaceID;
                OracleStorageProperties tmpProps = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (tmpProps == null || (tspaceID = tmpProps.getTablespaceID()) == null || !ModelUtil.hasLength((String)(tspaceName = DBUtil.getDBObjectName((DBObjectID)tspaceID)))) break;
                Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
                Node storageNode = this.findOrCreateNode(doc, physicalPropsNode, "HEAP_TABLE/SEGMENT_ATTRIBUTES/TABLESPACE");
                storageNode.appendChild(doc.createTextNode(tspaceName));
                break;
            }
            default: {
                OracleTableProperties otp;
                OracleStorageProperties props = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (props != null) {
                    Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
                    Node storageNode = this.findOrCreateNode(doc, physicalPropsNode, "HEAP_TABLE/SEGMENT_ATTRIBUTES");
                    this.getParentGenerator().populateNode(storageNode, doc, props);
                }
                Boolean compress = (otp = (OracleTableProperties)tab.getProperty("OracleTableProperties")) == null ? null : OracleTableProperties.OracleTableCompression.convertToBoolean((OracleTableProperties.OracleTableCompression)otp.getTableCompression());
                Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
                Node compressNode = this.findOrCreateNode(doc, physicalPropsNode, "HEAP_TABLE/COMPRESS");
                if (compress != null && compress.booleanValue()) {
                    compressNode.appendChild(doc.createTextNode("ALL"));
                    break;
                }
                compressNode.appendChild(doc.createTextNode("N"));
            }
        }
        if ((imp = (OracleInMemoryProperties)tab.getProperty("OracleInMemoryProperties")) != null) {
            Node physicalPropsNode = this.findOrCreatePhysicalPropertiesNode(doc, parent);
            Node inMemNode = this.findOrCreateNode(doc, physicalPropsNode, "INMEMORY");
            this.getParentGenerator().populateNode(inMemNode, doc, imp);
        }
    }

    private Node findOrCreatePhysicalPropertiesNode(Document doc, Node parent) {
        return this.findOrCreateNodeBefore(doc, parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES", "TABLE_PROPERTIES");
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        String compress;
        Node tempNode;
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        Table tab = (Table)obj;
        Node imNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/INMEMORY");
        if (imNode != null) {
            OracleInMemoryProperties imp = (OracleInMemoryProperties)tab.getProperty("OracleInMemoryProperties");
            if (imp == null) {
                imp = new OracleInMemoryProperties();
                tab.setProperty("OracleInMemoryProperties", (Object)imp);
            }
            reader.fillInObject(imp, imNode, null);
        }
        if ((tempNode = this.findNode(parent, "GLOBAL_TEMPORARY")) != null) {
            String onCommit = this.nodeText(parent, "RELATIONAL_TABLE/ON_COMMIT");
            if ("PRESERVE".equals(onCommit)) {
                tab.setProperty("TableType", (Object)Table.TableType.SESSION_TEMP);
            } else {
                tab.setProperty("TableType", (Object)Table.TableType.TRANSACTION_TEMP);
            }
            String tbsp = this.nodeText(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES/TABLESPACE");
            if (tbsp != null) {
                OracleStorageProperties osp = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    tab.setProperty("OracleStorageProperties", (Object)osp);
                }
                NameBasedID tbspId = new NameBasedID("TABLESPACE", null, tbsp);
                osp.setTablespaceID((DBObjectID)tbspId);
            }
            return;
        }
        Node iotNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/INDEX_ORGANIZED_TABLE");
        if (iotNode != null) {
            String iotKeyCompress;
            Node iotSegNode;
            tab.setProperty("TableType", (Object)Table.TableType.INDEX_ORGANIZED);
            OracleIndexOrganizedTableProperties iotProps = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties");
            if (iotProps == null) {
                iotProps = new OracleIndexOrganizedTableProperties();
                tab.setProperty("OracleIndexOrganizedTableProperties", (Object)iotProps);
            }
            reader.fillInObject(iotProps, iotNode, null);
            if (this.nodeExists(iotNode, "OVERFLOW")) {
                iotProps.setOverflowable(true);
            }
            if ((iotSegNode = this.findNode(iotNode, "SEGMENT_ATTRIBUTES")) != null) {
                OracleStorageProperties osp = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    tab.setProperty("OracleStorageProperties", (Object)osp);
                }
                reader.fillInObject(osp, iotSegNode, null);
            }
            if ("0".equals(iotKeyCompress = this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/IOT_KEYCOMPRESS"))) {
                iotProps.setKeyCompression(Integer.valueOf(0));
            }
            return;
        }
        Node externalNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/EXTERNAL_TABLE");
        if (externalNode != null) {
            tab.setProperty("TableType", (Object)Table.TableType.EXTERNAL);
            OracleExternalTableProperties extProps = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
            if (extProps == null) {
                extProps = new OracleExternalTableProperties();
                tab.setProperty("OracleExternalTableProperties", (Object)extProps);
            }
            reader.fillInObject(extProps, externalNode, null);
            return;
        }
        Node segAttrNode = this.findNode(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES");
        if (segAttrNode != null) {
            OracleStorageProperties osp = (OracleStorageProperties)tab.getProperty("OracleStorageProperties");
            if (osp == null) {
                osp = new OracleStorageProperties();
                tab.setProperty("OracleStorageProperties", (Object)osp);
            }
            reader.fillInObject(osp, segAttrNode, null);
        }
        if ("Y".equals(compress = this.nodeText(parent, "RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/COMPRESS")) || "ALL".equals(compress)) {
            OracleTableProperties otp = OracleTableProperties.findOrCreateOracleTableProperties((DBObject)tab);
            otp.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom((Object)true));
        }
    }
}

