/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ColumnSXMLGenerator
extends SXMLFragmentGenerator {
    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        block14: {
            block13: {
                if (!(obj instanceof Table)) break block13;
                Table tab = (Table)obj;
                for (Column col : tab.getColumns()) {
                    OracleColumnProperties ocp = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                    if (ocp == null || ocp.getOwnedObjects().length <= 0) continue;
                    Node colPropColPropsNode = this.findOrCreateNodeBefore(doc, parent, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES", "PARALLEL");
                    Node colPropColListNode = this.findOrCreateNode(doc, colPropColPropsNode, "COL_LIST");
                    Node colItem = this.createNode(doc, colPropColListNode, "COL_LIST_ITEM");
                    Node nameNode = this.findOrCreateNode(doc, colItem, "NAME");
                    nameNode.appendChild(doc.createTextNode(col.getName()));
                    try {
                        DataTypeUsage dtu = col.getDataTypeUsage();
                        DataType type = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                        if (type != null) {
                            Node typeNode = this.findOrCreateNode(doc, colItem, "DATATYPE");
                            typeNode.appendChild(doc.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(type, dtu)));
                        }
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML - could not resolve datatype for column {0}: {1}", new Object[]{DBUtil.getFullyQualifiedName((DBObject)col), dbe.getMessage()});
                    }
                    this.getParentGenerator().populateNode(colItem, doc, ocp);
                }
                break block14;
            }
            if (!(obj instanceof TablePartition)) break block14;
            TablePartition tabPart = (TablePartition)obj;
            for (LOBDescriptor ld : tabPart.getLOBDescriptors()) {
                for (DBObjectID colID : ld.getColumns()) {
                    Column col = null;
                    try {
                        col = (Column)colID.resolveID();
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                    if (col == null) continue;
                    Node colPropColListNode = this.findOrCreateNodeBefore(doc, parent, "COLUMN_PROPERTIES/COL_LIST", "SUBPARTITION_LIST");
                    Node colItem = this.createNode(doc, colPropColListNode, "COL_LIST_ITEM");
                    Node nameNode = this.findOrCreateNode(doc, colItem, "NAME");
                    nameNode.appendChild(doc.createTextNode(col.getName()));
                    Node typeNode = this.findOrCreateNode(doc, colItem, "DATATYPE");
                    DataType type = null;
                    try {
                        DataTypeUsage dtu = col.getDataTypeUsage();
                        type = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                        if (type != null) {
                            typeNode.appendChild(doc.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(type, dtu)));
                        }
                    }
                    catch (DBException dbe) {
                        dbe.printStackTrace();
                    }
                    Node lobNode = null;
                    if (LOBDescriptor.isVARRAYColumn((Column)col)) {
                        Node varrayNode = this.findOrCreateNodeAfter(doc, colItem, "VARRAY_PROPERTIES", "DATATYPE");
                        Node storeAsNode = this.createNode(doc, varrayNode, "STORE_AS");
                        storeAsNode.appendChild(doc.createTextNode("LOB"));
                        lobNode = this.createNode(doc, varrayNode, "LOB_PROPERTIES/STORAGE_TABLE");
                    } else {
                        lobNode = this.findOrCreateNodeAfter(doc, colItem, "LOB_PROPERTIES/STORAGE_TABLE", "DATATYPE");
                    }
                    this.getParentGenerator().populateNode(lobNode, doc, ld);
                }
            }
        }
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        if (obj instanceof Table) {
            Table tab = (Table)obj;
            Node colListNode = this.findNode(parent, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST");
            if (colListNode != null) {
                SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
                while (it.hasNext()) {
                    Node colNode = (Node)it.next();
                    String colName = this.nodeText(colNode, "NAME");
                    Column col = tab.getColumn(colName);
                    OracleColumnProperties ocp = new OracleColumnProperties();
                    col.setProperty("OracleColumnProperties", (Object)ocp);
                    reader.fillInObject(ocp, colNode, null);
                    if (!this.nodeExists(colNode, "XMLTYPE_PROPERTIES/ELEMENT")) continue;
                    String owningSchemaName = this.getXmlSchemaOwningSchemaName(parent, colName);
                    String xmlSchemaName = this.nodeText(colNode, "XMLTYPE_PROPERTIES/XMLSCHEMA");
                    String elementName = this.nodeText(colNode, "XMLTYPE_PROPERTIES/ELEMENT");
                    NameBasedID xmlschemaID = new NameBasedID("XML SCHEMA", owningSchemaName, xmlSchemaName);
                    NameBasedID elementID = new NameBasedID("XMLSchemaElement", elementName, (DBObjectID)xmlschemaID);
                    ocp.getXMLTypeColumnProperties().setElementID((DBObjectID)elementID);
                }
            }
        } else if (obj instanceof TablePartition) {
            boolean bl = false;
        }
    }

    private String getXmlSchemaOwningSchemaName(Node parent, String columnName) {
        String retval = null;
        Node colListNode = this.findNode(parent, "RELATIONAL_TABLE/COL_LIST");
        if (colListNode != null) {
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(colListNode);
            while (it.hasNext()) {
                Node colNode = (Node)it.next();
                String colName = this.nodeText(colNode, "NAME");
                if (!colName.equals(columnName)) continue;
                retval = this.nodeText(colNode, "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER");
                break;
            }
        }
        return retval;
    }
}

