/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class UserFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids;
        int i;
        FunctionUsage retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if ((helper.isRule(node, "object_access_expression", "user_defined_function") || !context.getQueryBuilder().matchesProvider() && helper.isRule(node, "function", "aggregate_function")) && (i = helper.getKeywordIndex(kids = helper.getOrderedChildren(node), "(")) > 0) {
            List<ParseNode> names = helper.getDotSeparatedList(kids.subList(0, i));
            StringBuilder compoundName = new StringBuilder();
            for (ParseNode nn : names) {
                String nameBit;
                if (compoundName.length() > 0) {
                    compoundName.append(".");
                }
                if ((nameBit = helper.getContent(nn)).charAt(0) != '\"') {
                    nameBit = nameBit.toUpperCase();
                }
                nameBit = context.getProvider().getExternalName(nameBit, "SQLFragment");
                compoundName.append(nameBit);
            }
            SQLFragment[] argsL = context.getArgList(retval, node);
            retval = new FunctionUsage();
            retval.setObjectID(context.findIdForFunctionString(compoundName.toString()));
            retval.setArguments(argsL);
        }
        return retval;
    }
}

