/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class GroupByExpressionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        GroupByExpression groupByE;
        ExpressionList retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(node, "expression_list")) {
            retval = new ExpressionList();
        } else if (helper.isRule(node, "rollup_cube_clause")) {
            groupByE = new GroupByExpression();
            retval = groupByE;
            List<ParseNode> kids = helper.getOrderedChildren(node);
            if (helper.isKeyword(kids.get(0), "ROLLUP")) {
                groupByE.setGroupByType(GroupByExpression.GroupingType.ROLLUP);
            } else if (helper.isKeyword(kids.get(0), "CUBE")) {
                groupByE.setGroupByType(GroupByExpression.GroupingType.CUBE);
            }
        } else if (helper.isRule(node, "grouping_sets_clause")) {
            groupByE = new GroupByExpression();
            retval = groupByE;
            groupByE.setGroupByType(GroupByExpression.GroupingType.GROUPING_SETS);
        }
        if (retval != null) {
            SQLFragment[] args;
            List<ParseNode> kids = helper.getOrderedChildren(node);
            boolean nest = false;
            ParseNode gel = helper.getRuleNode(kids, "grouping_expression_list");
            if (gel == null) {
                gel = helper.getRuleNode(kids, "\"expr_list\"");
            }
            if (gel != null) {
                List<ParseNode> gelkids = helper.getOrderedChildren(gel);
                nest = helper.isKeyword(gelkids.get(0), "(");
            }
            if ((args = context.getArgList(retval, gel)).length == 1 && args[0] instanceof ExpressionList && helper.isRule(node, "rollup_cube_clause")) {
                args = ((ExpressionList)args[0]).getArguments();
            }
            if (retval instanceof GroupByExpression) {
                if (nest) {
                    args = new SQLFragment[]{new ExpressionList(args)};
                }
                ((GroupByExpression)retval).setArguments(args);
            } else {
                retval.setArguments(args);
            }
        }
        return retval;
    }
}

