/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.XMLFunctionUsage;

public class BuiltInFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval = null;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(node);
        DBObjectProvider pro = context.getProvider();
        String source = pro.getInternalName(helper.getContent(kids.get(0)));
        BuiltInFunction func = null;
        Iterator iterator = pro.getDescriptor().listBuiltInFunctions(source).iterator();
        if (iterator.hasNext()) {
            BuiltInFunction bif;
            func = bif = (BuiltInFunction)iterator.next();
        }
        if (func != null) {
            if (helper.isRule(node, "XML_function", "xmlexists", "xmltable", "xmlagg") && helper.isKeyword(kids.get(1), "(") && helper.isKeyword(kids.get(kids.size() - 1), ")")) {
                retval = this.createXMLFunction(context, kids, source, func);
            } else if ((helper.isRule(node, "function_expression") || helper.isRule(node, "JSON_exists_condition") || helper.isRule(node, "JSON_textcontains_condition")) && helper.isLeaf(kids.get(0))) {
                if (func == null) {
                    if (helper.isKeyword(kids.get(0), "MULTISET")) {
                        retval = this.createMultiset(kids.get(2), context);
                    }
                } else {
                    String distinctQualifierSource = null;
                    boolean isDistinct = false;
                    if (helper.isRule(node, "cast")) {
                        SQLFragment arg0 = null;
                        if (helper.isKeyword(kids.get(2), "MULTISET")) {
                            List<ParseNode> kidskids = helper.getOrderedChildren(kids.get(3));
                            arg0 = this.createMultiset(kidskids.get(1), context);
                        } else {
                            arg0 = context.createFragment(kids.get(2), context.getCreating());
                        }
                        ParseNode datatypeNode = helper.getRuleNode(kids, "datatype");
                        String datatype = helper.getContent(datatypeNode);
                        SimpleSQLFragment arg1 = new SimpleSQLFragment(datatype);
                        SQLFragment[] argsL = new SQLFragment[]{arg0, arg1};
                        retval = context.createFunction(source, func, null, false, argsL);
                    } else {
                        int distinctAllIndex;
                        if (helper.isRule(node, "trim")) {
                            BuiltInFunction bif;
                            Iterator arg0;
                            if (helper.getKeywordIndex(kids, "LEADING") != -1) {
                                source = "LEADING";
                                arg0 = context.getProvider().getDescriptor().listBuiltInFunctions("LTRIM").iterator();
                                if (arg0.hasNext()) {
                                    func = bif = (BuiltInFunction)arg0.next();
                                }
                            } else if (helper.getKeywordIndex(kids, "TRAILING") != -1) {
                                source = "TRAILING";
                                arg0 = context.getProvider().getDescriptor().listBuiltInFunctions("RTRIM").iterator();
                                if (arg0.hasNext()) {
                                    func = bif = (BuiltInFunction)arg0.next();
                                }
                            } else if (helper.getKeywordIndex(kids, "BOTH") != -1) {
                                source = "BOTH";
                            }
                        }
                        if ((distinctAllIndex = helper.getKeywordIndex(kids, "DISTINCT", "ALL")) != -1) {
                            distinctQualifierSource = helper.getContent(kids.get(distinctAllIndex));
                            isDistinct = helper.getKeywordIndex(kids, "DISTINCT") != -1;
                        }
                        SQLFragment[] argsL = null;
                        if (helper.isRule(node, "translate_using")) {
                            SQLFragment arg0 = context.createFragment(kids.get(2), context.getCreating());
                            SimpleSQLFragment arg1 = new SimpleSQLFragment(helper.getContent(kids.get(4)));
                            argsL = new SQLFragment[]{arg0, arg1};
                        } else {
                            argsL = context.getArgList(func.getName(), node);
                        }
                        retval = context.createFunction(source, func, distinctQualifierSource, isDistinct, argsL);
                    }
                }
            }
        }
        return retval;
    }

    private SQLFragment createMultiset(ParseNode node, ExpressionContext context) throws SQLQueryException {
        Function retval = null;
        SQLFragment multisetQuery = context.createFragment(node, context.getCreating(), context.getQueryContext());
        retval = new Function("MULTISET", new SQLFragment[]{multisetQuery});
        context.getQueryBuilder().setFunctionReturnTypeID(retval);
        return retval;
    }

    private SQLFragment createXMLFunction(ExpressionContext context, List<ParseNode> xmlNodes, String source, BuiltInFunction func) throws SQLQueryException {
        List<SQLFragment> frags = this.createXMLargs(context, xmlNodes.subList(2, xmlNodes.size() - 1));
        SQLFragment[] argsL = frags.toArray(new SQLFragment[frags.size()]);
        XMLFunctionUsage retval = new XMLFunctionUsage();
        retval.setObjectID(context.findIdForFunctionString(func.getName()));
        retval.setArguments(argsL);
        return retval;
    }

    private List<SQLFragment> createXMLargs(ExpressionContext context, List<ParseNode> nodes) throws SQLQueryException {
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        ArrayList<Object> nodesToProcess = new ArrayList<ParseNode>();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        for (ParseNode n : nodes) {
            String debugContent = helper.getContent(n);
            if (this.hasExpr(n, context)) {
                if (nodesToProcess.size() > 0) {
                    retval.add(this.createStringFragment(nodesToProcess, context));
                    nodesToProcess = new ArrayList();
                }
                if (helper.isRule(n, "expr")) {
                    try {
                        retval.add(context.createFragment(n, context.getCreating()));
                        continue;
                    }
                    catch (SQLQueryCancelledException sqce) {
                        throw sqce;
                    }
                    catch (SQLQueryException e) {
                        retval.add((SQLFragment)new SimpleSQLFragment(helper.getContent(n)));
                        continue;
                    }
                }
                List<ParseNode> kids = helper.getOrderedChildren(n);
                retval.addAll(this.createXMLargs(context, kids));
                continue;
            }
            nodesToProcess.add(n);
        }
        if (nodesToProcess.size() > 0) {
            retval.add(this.createStringFragment(nodesToProcess, context));
        }
        return retval;
    }

    private SQLFragment createStringFragment(List<ParseNode> nodes, ExpressionContext context) {
        StringBuilder buf = new StringBuilder();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(helper.getContent(nodes.get(i)));
        }
        return new SimpleSQLFragment(buf.toString());
    }

    private boolean hasExpr(ParseNode n, ExpressionContext context) {
        boolean retval = false;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(n, "expr")) {
            retval = true;
        } else if (!helper.isLeaf(n)) {
            List<ParseNode> kids = helper.getOrderedChildren(n);
            for (ParseNode kid : kids) {
                if (!this.hasExpr(kid, context)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }
}

