/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;

public class OMBTablePartitionDefPropsBuilder
extends OMBStoragePropsBuilder<TablePartition> {
    public OMBTablePartitionDefPropsBuilder(Object forPartition) {
        super((TablePartition)forPartition, "segmentAttributes");
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        this.registerPropertyMapping("values", new OMBPartitionValuePropResolver((TablePartition)this.getContextObject()));
        this.registerPropertyMapping("compression", "DATA_SEGMENT_COMPRESSION");
        HashMap<String, String> compMap = new HashMap<String, String>();
        compMap.put("true", "COMPRESS");
        compMap.put("false", "NOCOMPRESS");
        this.registerSubstitutionValues("DATA_SEGMENT_COMPRESSION", (HashMap)compMap);
    }

    public final class OMBPartitionValuePropResolver
    implements OMBSinglePropertyResolver {
        TablePartition m_partition = null;
        final String COMMA = ",";

        public OMBPartitionValuePropResolver(TablePartition partition) {
            this.m_partition = partition;
        }

        @Override
        public String resolvePropertyValue() {
            if (this.m_partition.getValues() != null) {
                StringBuffer valuesBuff = new StringBuffer();
                boolean firstTimeAround = true;
                for (int i = 0; i < this.m_partition.getValues().length; ++i) {
                    String value;
                    if (!firstTimeAround) {
                        valuesBuff.append(",");
                    }
                    if ((value = this.m_partition.getValues()[i].toString()).indexOf("'") != -1) {
                        value = this.stripQuotes(value);
                        valuesBuff.append("''");
                        valuesBuff.append(value);
                        valuesBuff.append("''");
                    } else {
                        valuesBuff.append(value);
                    }
                    firstTimeAround = false;
                }
                if (valuesBuff.length() == 0) {
                    return null;
                }
                return valuesBuff.toString();
            }
            return null;
        }

        @Override
        public String resolvePropertyName() {
            if (this.m_partition.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.LIST)) {
                return "VALUES_EQUAL_TO";
            }
            return "VALUES_LESS_THAN";
        }

        private String stripQuotes(String value) {
            if (value.contains("'")) {
                value = value.replaceAll("'", "");
            }
            return value;
        }
    }
}

