/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.owb.OMBColumnPropsBuilder;
import oracle.javatools.db.ora.owb.OMBConstraintPropsBuilder;
import oracle.javatools.db.ora.owb.OMBExtTablePropsBuilder;
import oracle.javatools.db.ora.owb.OMBIndexPartitionDefPropsBuilder;
import oracle.javatools.db.ora.owb.OMBIndexPartitioningPropsBuilder;
import oracle.javatools.db.ora.owb.OMBIndexPropsBuilder;
import oracle.javatools.db.ora.owb.OMBMDLType;
import oracle.javatools.db.ora.owb.OMBMatViewPropsBuilder;
import oracle.javatools.db.ora.owb.OMBPartitioningPropsBuilder;
import oracle.javatools.db.ora.owb.OMBPlsAttributePropsBuilder;
import oracle.javatools.db.ora.owb.OMBPlsParamPropsBuilder;
import oracle.javatools.db.ora.owb.OMBPlsSubProgPropsBuilder;
import oracle.javatools.db.ora.owb.OMBSequencePropsBuilder;
import oracle.javatools.db.ora.owb.OMBTablePartitionDefPropsBuilder;
import oracle.javatools.db.ora.owb.OMBTablePropsBuilder;
import oracle.javatools.db.ora.owb.OMBViewPropsBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;

public final class OMBMDLGenerator
extends BundleDDLGenerator<OMBMDLType> {
    public OMBMDLGenerator(DBObjectProvider pro) {
        super(Oracle11gR2.class, pro, new String[]{"/oracle/javatools/db/ora/owb/OMBMDL.properties"});
        this.registerTokenGenerator("table.setprops", new OMBSetTablePropertiesGenerator());
        this.registerTokenGenerator("exttable.setprops", new OMBSetExtTablePropertiesGenerator());
        this.registerTokenGenerator("col.setprops", new OMBSetColumnPropertiesGenerator());
        this.registerTokenGenerator("index.setprops", new OMBSetIndexPropertiesGenerator());
        this.registerTokenGenerator("indexpartitioning.setprops", new OMBSetIndexPartitioningPropertiesGenerator());
        this.registerTokenGenerator("indexpartitiondef.setprops", new OMBSetIndexPartitionDefPropertiesGenerator());
        this.registerTokenGenerator("constraint.setprops", new OMBSetConstraintPropertiesGenerator());
        this.registerTokenGenerator("partitioning.setprops", new OMBSetPartitioningPropertiesGenerator());
        this.registerTokenGenerator("partitiondef.setprops", new OMBSetPartitionDefPropertiesGenerator());
        this.registerTokenGenerator("sequence.setprops", new OMBSetSequencePropertiesGenerator());
        this.registerTokenGenerator("view.setprops", new OMBSetViewPropertiesGenerator());
        this.registerTokenGenerator("plssubprog.setprops", new OMBSetPlsSubProgPropertiesGenerator());
        this.registerTokenGenerator("param.setprops", new OMBSetPlsParamPropertiesGenerator());
        this.registerTokenGenerator("matview.setprops", new OMBSetMatViewPropertiesGenerator());
        this.registerTokenGenerator("attribute.setprops", new OMBSetPlsAttributePropertiesGenerator());
        this.registerTokenGenerator("index.bitmapcol", new OMBSetBitmapColTokenGenerator());
    }

    protected OMBMDLType getDDLType(String type) {
        return OMBMDLType.getDDLType(type);
    }

    public static final class OMBSetBitmapColTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "index.bitmapcol";

        public void generateToken(TokenContext context) {
            Object colExpr = context.getObject();
            if (colExpr instanceof SQLFragment) {
                if (colExpr instanceof ColumnUsage) {
                    context.append((Object)((ColumnUsage)colExpr).getColumnName());
                } else {
                    int endIndx = colExpr.toString().lastIndexOf("ASC");
                    if (endIndx != -1) {
                        context.append((Object)colExpr.toString().substring(0, endIndx).trim());
                    } else {
                        context.append((Object)colExpr.toString());
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetMatViewPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "matview.setprops";

        public void generateToken(TokenContext context) {
            OMBMatViewPropsBuilder gen = new OMBMatViewPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetPlsParamPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "param.setprops";

        public void generateToken(TokenContext context) {
            OMBPlsParamPropsBuilder gen = new OMBPlsParamPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetPlsAttributePropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "attribute.setprops";

        public void generateToken(TokenContext context) {
            OMBPlsAttributePropsBuilder gen = new OMBPlsAttributePropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetPlsSubProgPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "plssubprog.setprops";

        public void generateToken(TokenContext context) {
            OMBPlsSubProgPropsBuilder gen = new OMBPlsSubProgPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetViewPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "view.setprops";

        public void generateToken(TokenContext context) {
            OMBViewPropsBuilder gen = new OMBViewPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetPartitionDefPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "partitiondef.setprops";
        private String m_propsStatement = null;

        public void setPropBuilder(TokenContext context) {
            OMBTablePartitionDefPropsBuilder gen = new OMBTablePartitionDefPropsBuilder(context.getObject());
            this.m_propsStatement = gen.getPropertiesStatement();
        }

        public void generateToken(TokenContext context) {
            this.setPropBuilder(context);
            if (this.m_propsStatement != null) {
                context.append((Object)this.m_propsStatement);
            }
        }

        public Object evaluateToken(TokenContext context) {
            this.setPropBuilder(context);
            return this.m_propsStatement != null;
        }
    }

    public static final class OMBSetPartitioningPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "partitioning.setprops";
        private String m_propsStatement = null;

        public void setPropBuilder(TokenContext context) {
            OMBPartitioningPropsBuilder gen = new OMBPartitioningPropsBuilder(context.getObject());
            this.m_propsStatement = gen.getPropertiesStatement();
        }

        public void generateToken(TokenContext context) {
            this.setPropBuilder(context);
            if (this.m_propsStatement != null) {
                context.append((Object)this.m_propsStatement);
            }
        }

        public Object evaluateToken(TokenContext context) {
            this.setPropBuilder(context);
            return this.m_propsStatement != null;
        }
    }

    public static final class OMBSetSequencePropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "sequence.setprops";

        public void generateToken(TokenContext context) {
            OMBSequencePropsBuilder gen = new OMBSequencePropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetConstraintPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "constraint.setprops";

        public void generateToken(TokenContext context) {
            OMBConstraintPropsBuilder gen = new OMBConstraintPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetIndexPartitionDefPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "indexpartitiondef.setprops";
        private String m_propsStatement = null;

        public void setPropBuilder(TokenContext context) {
            OMBIndexPartitionDefPropsBuilder gen = new OMBIndexPartitionDefPropsBuilder(context.getObject());
            this.m_propsStatement = gen.getPropertiesStatement();
        }

        public void generateToken(TokenContext context) {
            this.setPropBuilder(context);
            if (this.m_propsStatement != null) {
                context.append((Object)this.m_propsStatement);
            }
        }

        public Object evaluateToken(TokenContext context) {
            this.setPropBuilder(context);
            return this.m_propsStatement != null;
        }
    }

    public static final class OMBSetIndexPartitioningPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "indexpartitioning.setprops";

        public void generateToken(TokenContext context) {
            OMBIndexPartitioningPropsBuilder gen = new OMBIndexPartitioningPropsBuilder(context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetIndexPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "index.setprops";

        public void generateToken(TokenContext context) {
            OMBIndexPropsBuilder gen = new OMBIndexPropsBuilder((Index)context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetColumnPropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "col.setprops";

        public void generateToken(TokenContext context) {
            OMBColumnPropsBuilder gen = new OMBColumnPropsBuilder((Column)context.getObject());
            String expandedToken = gen.getPropertiesStatement();
            if (expandedToken != null) {
                context.append((Object)expandedToken);
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    public static final class OMBSetExtTablePropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "exttable.setprops";
        private String m_propsStatement = null;

        public void setPropBuilder(TokenContext context) {
            OMBExtTablePropsBuilder gen = new OMBExtTablePropsBuilder(context.getObject());
            this.m_propsStatement = gen.getPropertiesStatement();
        }

        public void generateToken(TokenContext context) {
            this.setPropBuilder(context);
            if (this.m_propsStatement != null) {
                context.append((Object)this.m_propsStatement);
            }
        }

        public Object evaluateToken(TokenContext context) {
            this.setPropBuilder(context);
            return this.m_propsStatement != null;
        }
    }

    public static final class OMBSetTablePropertiesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "table.setprops";
        private String m_propsStatement = null;

        public void setPropBuilder(TokenContext context) {
            OMBTablePropsBuilder gen = new OMBTablePropsBuilder((Table)context.getObject());
            this.m_propsStatement = gen.getPropertiesStatement();
        }

        public void generateToken(TokenContext context) {
            this.setPropBuilder(context);
            if (this.m_propsStatement != null) {
                context.append((Object)this.m_propsStatement);
            }
        }

        public Object evaluateToken(TokenContext context) {
            this.setPropBuilder(context);
            return this.m_propsStatement != null;
        }
    }
}

