/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.IndexObject;

class OMBIndexPropsBuilder
extends OMBStoragePropsBuilder<Index> {
    public OMBIndexPropsBuilder(Object forIndex) {
        super((Index)forIndex, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties"}));
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        Index index = (Index)this.getContextObject();
        if (!(index.getParent() instanceof MaterializedView)) {
            this.registerPropertyMapping("parallelDegree", new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
            HashMap<String, String> parallelMap = new HashMap<String, String>();
            parallelMap.put("$DEFAULT$", "PARALLEL");
            this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)parallelMap);
        }
        this.registerPropertyMapping("keyCompression", new String[]{"KEYCOMPRESS", "KEYCOMPRESSPREFIXLENGTH"});
        HashMap<String, String> compressMap = new HashMap<String, String>();
        compressMap.put("$DEFAULT$", "COMPRESS");
        this.registerSubstitutionValues("KEYCOMPRESS", (HashMap)compressMap);
        if (index.getIndexType() != Index.IndexType.BITMAP && index.getIndexType() != Index.IndexType.UNIQUE) {
            this.registerPropertyMapping("columnExpressions", new OMBColExpressionPropResolver());
        }
        this.registerPropertyMapping("indexType", 1, "INDEX_TYPE");
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("NORMAL", "FUNCTION-BASED");
        this.registerSubstitutionValues("INDEX_TYPE", (HashMap)typeMap);
        String oipProp = Property.createPath((String[])new String[]{"properties", "OracleIndexPartitions"});
        this.registerPropertyMapping(oipProp, new OMBIsLocalIndxPropResolver(oipProp));
    }

    public final class OMBIsLocalIndxPropResolver
    implements OMBSinglePropertyResolver {
        final String m_prop;

        OMBIsLocalIndxPropResolver(String prop) {
            this.m_prop = prop;
        }

        @Override
        public String resolvePropertyValue() {
            OracleIndexPartitions oip;
            PropertyHelper ph = new PropertyHelper();
            Object propVal = ph.getPropertyValue((Object)OMBIndexPropsBuilder.this.getContextObject(), this.m_prop);
            if (propVal != null && propVal instanceof OracleIndexPartitions && ((oip = (OracleIndexPartitions)propVal).getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_HASH) || oip.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_COMP) || oip.getPartitionType().equals((Object)OracleIndexPartitions.PartitionType.LOCAL_OTHER))) {
                return "true";
            }
            return "false";
        }

        @Override
        public String resolvePropertyName() {
            return "LOCAL_INDEX";
        }
    }

    public final class OMBColExpressionPropResolver
    implements OMBSinglePropertyResolver {
        final String COMMA = ",";

        @Override
        public String resolvePropertyValue() {
            StringBuffer colBuff = new StringBuffer();
            boolean firstTimeAround = true;
            for (IndexObject io : ((Index)OMBIndexPropsBuilder.this.getContextObject()).getColumnExpressions()) {
                if (!firstTimeAround) {
                    colBuff.append(",");
                }
                String exp = io.getExpressionSource();
                colBuff.append(exp);
                if (IndexObject.OrderType.DESC.equals((Object)io.getOrderType())) {
                    colBuff.append(" DESC");
                }
                firstTimeAround = false;
            }
            return colBuff.toString();
        }

        @Override
        public String resolvePropertyName() {
            return "COLUMN_EXPRESSION";
        }
    }
}

