/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;

class OMBIndexPartitionDefPropsBuilder
extends OMBPropsStatementBuilder<IndexPartition> {
    public OMBIndexPartitionDefPropsBuilder(Object forIndexPartition) {
        super((IndexPartition)forIndexPartition);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("valuesLessThan", new OMBIndexPartitionValuePropResolver());
    }

    public final class OMBIndexPartitionValuePropResolver
    implements OMBSinglePropertyResolver {
        final String COMMA = ",";

        @Override
        public String resolvePropertyValue() {
            IndexPartition ip = (IndexPartition)OMBIndexPartitionDefPropsBuilder.this.getContextObject();
            if (ip.getValuesLessThan() != null) {
                StringBuilder valuesBuff = new StringBuilder();
                boolean firstTimeAround = true;
                for (int i = 0; i < ip.getValuesLessThan().length; ++i) {
                    if (!firstTimeAround) {
                        valuesBuff.append(",");
                    }
                    valuesBuff.append(ip.getValuesLessThan()[i]);
                    firstTimeAround = false;
                }
                if (valuesBuff.length() == 0) {
                    return null;
                }
                return valuesBuff.toString();
            }
            return null;
        }

        @Override
        public String resolvePropertyName() {
            return "VALUES_LESS_THAN";
        }
    }
}

