/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;

class OMBConstraintPropsBuilder
extends OMBPropsStatementBuilder<Constraint> {
    public OMBConstraintPropsBuilder(Object forConstraint) {
        super((Constraint)forConstraint);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("enabled", "ENABLECONSTRAINT");
        HashMap<String, String> enabledMap = new HashMap<String, String>();
        enabledMap.put("true", "ENABLE");
        enabledMap.put("false", "DISABLE");
        this.registerSubstitutionValues("ENABLECONSTRAINT", enabledMap);
        this.registerPropertyMapping("deferrableState", new String[]{"DEFERRABLE", "INITIALLY"});
        HashMap<String, String> deferMap = new HashMap<String, String>();
        deferMap.put("DEFER_INIT_IMMEDIATE", "DEFERRABLE");
        deferMap.put("DEFER_INIT_DEFERRED", "DEFERRABLE");
        this.registerSubstitutionValues("DEFERRABLE", deferMap);
        HashMap<String, String> initiallyMap = new HashMap<String, String>();
        initiallyMap.put("DEFER_INIT_IMMEDIATE", "IMMEDIATE");
        initiallyMap.put("DEFER_INIT_DEFERRED", "DEFERRED");
        this.registerSubstitutionValues("INITIALLY", initiallyMap);
        this.registerPropertyMapping("onDeleteAction", "ONDELETE");
        HashMap<String, String> deleteMap = new HashMap<String, String>();
        deleteMap.put("RESTRICT", "$IGNORE$");
        deleteMap.put("CASCADE", "CASCADE");
        deleteMap.put("SET NULL", "SET NULL");
        this.registerSubstitutionValues("ONDELETE", deleteMap);
        this.registerPropertyMapping("checkCondition", new OMBCheckConditionQueryPropResolver());
    }

    public final class OMBCheckConditionQueryPropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            Constraint con = (Constraint)OMBConstraintPropsBuilder.this.getContextObject();
            if (con instanceof CheckConstraint) {
                String consText = ((CheckConstraint)con).getCheckCondition();
                return consText == null ? null : consText.trim().replaceAll("'", "''");
            }
            return null;
        }

        @Override
        public String resolvePropertyName() {
            return "CHECK_CONDITION";
        }
    }
}

