/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropertyValidator;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

class OMBColumnPropsBuilder
extends OMBPropsStatementBuilder<Column> {
    public OMBColumnPropsBuilder(Object forColumn) {
        super((Column)forColumn);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        DBObjectID dbObjId;
        DataTypeUsage dtu;
        Column col = (Column)this.getContextObject();
        String datatypeIdNameProp = Property.createPath((String[])new String[]{"dataTypeUsage", "dataTypeID", "name"});
        this.registerPropertyMapping(datatypeIdNameProp, "DATATYPE");
        this.registerPropertyMapping("default", new OMBColDefaultValuePropResolver());
        PropertyHelper ph = new PropertyHelper();
        String tableTypeProp = Property.createPath((String[])new String[]{"properties", "TableType"});
        Object tabType = ph.getPropertyValue((Object)col.getParent(), tableTypeProp);
        if (tabType == null || tabType != Table.TableType.EXTERNAL) {
            this.registerPropertyMapping("notNull", "NOT_NULL");
            HashMap<String, String> notNullSubVals = new HashMap<String, String>();
            notNullSubVals.put("true", "1");
            notNullSubVals.put("false", "0");
            this.registerSubstitutionValues("NOT_NULL", notNullSubVals);
        }
        if ((dtu = col.getDataTypeUsage()) != null && (dbObjId = dtu.getDataTypeID()) instanceof DataTypeID) {
            String scaleProp = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "scale"});
            DataTypeID dtID = (DataTypeID)dbObjId;
            if (dtID.getTypeName().equals("TIMESTAMP")) {
                this.registerPropertyMapping(scaleProp, "FRACTIONAL_SECONDS_PRECISION");
            } else {
                this.registerPropertyMapping(scaleProp, "SCALE");
            }
        }
        String precisionProp = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "precision"});
        String sizeProp = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "size"});
        this.registerPropertyMapping(precisionProp, "PRECISION");
        this.registerPropertyMapping(sizeProp, "LENGTH");
        this.registerPropertyValidator("DATATYPE", new OMBDatatypePropValidator());
        this.registerPropertyMapping("virtualExpressionSource", new OMBColVirtualExpressionPropResolver());
    }

    public final class OMBDatatypePropValidator
    extends OMBPropertyValidator {
        final Set<String> m_validDatatypes = new HashSet<String>();

        void setValidDataTypes() {
            this.m_validDatatypes.add("BINARY_DOUBLE");
            this.m_validDatatypes.add("BINARY_FLOAT");
            this.m_validDatatypes.add("BLOB");
            this.m_validDatatypes.add("CHAR");
            this.m_validDatatypes.add("CLOB");
            this.m_validDatatypes.add("DATE");
            this.m_validDatatypes.add("FLOAT");
            this.m_validDatatypes.add("INTEGER");
            this.m_validDatatypes.add("INTERVAL DAY");
            this.m_validDatatypes.add("INTERVAL YEAR");
            this.m_validDatatypes.add("NCHAR");
            this.m_validDatatypes.add("NCLOB");
            this.m_validDatatypes.add("NUMBER");
            this.m_validDatatypes.add("NVARCHAR2");
            this.m_validDatatypes.add("RAW");
            this.m_validDatatypes.add("SYS.ANYDATA");
            this.m_validDatatypes.add("SYS.LCR$_ROW_RECORD");
            this.m_validDatatypes.add("SYS.XMLFORMAT");
            this.m_validDatatypes.add("TIMESTAMP");
            this.m_validDatatypes.add("VARCHAR");
            this.m_validDatatypes.add("VARCHAR2");
            this.m_validDatatypes.add("XMLTYPE");
        }

        @Override
        public void validateProperty(String propName, String propValue) {
            this.setValidDataTypes();
            if (!this.m_validDatatypes.contains(propValue)) {
                DBLog.getLogger((Object)this).warning("Column datatype " + propValue + " is not supported in OMB Script");
            }
        }
    }

    public final class OMBColDefaultValuePropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            String defaultVal = (String)((Column)OMBColumnPropsBuilder.this.getContextObject()).getDefault();
            return defaultVal.trim().replaceAll("'", "''");
        }

        @Override
        public String resolvePropertyName() {
            return "DEFAULT_VALUE";
        }
    }

    public final class OMBColVirtualExpressionPropResolver
    implements OMBPropertyResolver {
        @Override
        public String[] resolvePropertyValues() {
            String[] stringArray;
            String expr = ((Column)OMBColumnPropsBuilder.this.getContextObject()).getVirtualExpressionSource();
            if (!ModelUtil.hasLength((String)expr)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "true";
                stringArray = stringArray2;
                stringArray2[1] = expr;
            }
            return stringArray;
        }

        @Override
        public String[] resolvePropertyNames() {
            String[] stringArray;
            String expr = ((Column)OMBColumnPropsBuilder.this.getContextObject()).getVirtualExpressionSource();
            if (!ModelUtil.hasLength((String)expr)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "VIRTUAL";
                stringArray = stringArray2;
                stringArray2[1] = "EXPRESSION";
            }
            return stringArray;
        }
    }
}

