/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.lite;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.ddl.OracleLiteDDLGenerator;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;

public class OracleDatabaseLiteDescriptor
extends OracleDatabaseDescriptor {
    public OracleDatabaseLiteDescriptor(int version) {
        super(version == 103 ? OracleLite10gR3.class : OracleLite.class, version);
    }

    public OracleDatabaseLiteDescriptor(Class<? extends OracleDatabaseLite> databaseClass) {
        super(databaseClass, OracleLite10gR3.class.isAssignableFrom(databaseClass) ? 103 : 101);
    }

    @Override
    public String getDatabaseType() {
        return "Oracle Lite";
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new OracleLiteDDLGenerator(this.getDatabaseClass(), pro);
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        int version;
        String type = this.getDatabaseType();
        if ("Oracle Lite".equals(type) && (version = this.getDatabaseVersion()) == 101) {
            cache.registerDataType("BIGINT");
            cache.registerDataType("BINARY");
            cache.registerDataType("BIT");
            cache.registerDataType("BLOB");
            cache.registerDataType("CHAR");
            cache.registerDataType("CLOB");
            cache.registerDataType("DATE");
            cache.registerDataType("DECIMAL");
            cache.registerDataType("DOUBLE PRECISION");
            cache.registerDataType("FLOAT");
            cache.registerDataType("INTEGER");
            cache.registerDataType("LONG RAW");
            cache.registerDataType("LONG VARBINARY");
            cache.registerDataType("LONG VARCHAR");
            cache.registerDataType("LONG");
            cache.registerDataType("NUMBER");
            cache.registerDataType("NUMERIC");
            cache.registerDataType("RAW");
            cache.registerDataType("REAL");
            cache.registerDataType("ROWID");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("TIME");
            cache.registerDataType("TIMESTAMP");
            cache.registerDataType("TINYINT");
            cache.registerDataType("VARBINARY");
            cache.registerDataType("VARCHAR");
            cache.registerDataType("VARCHAR2");
        }
    }
}

