/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.bigdata.BigDataTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataTableProperty;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class BigDataTablePropertiesBuilder
extends BigDataAccessParameterBuilder.ValueBuilder {
    @Override
    public void buildFragment(BigDataAccessParameter param) throws DBException {
        String value = this.stripAndTrimParentheses(param.getParameterValue());
        if (ModelUtil.hasLength((String)value)) {
            ArrayList<BigDataTableProperty> props = new ArrayList<BigDataTableProperty>();
            int length = value.length();
            BigDataTableProperty building = new BigDataTableProperty();
            StringBuilder bit = new StringBuilder();
            boolean buildingName = true;
            for (int i = 0; i < length; ++i) {
                boolean finishProp = false;
                boolean finishBit = false;
                char c = value.charAt(i);
                if (c == ',') {
                    finishProp = true;
                    finishBit = true;
                } else if (c == '=' && buildingName) {
                    finishBit = true;
                } else if (!Character.isWhitespace(c)) {
                    if (c == '\"') {
                        int end = this.findMatchingDoubleQuote(param, value, i);
                        bit.append(value.substring(i + 1, end));
                        i = end;
                    } else if (c == '\'') {
                        int end = this.findMatchingSingleQuote(param, value, i);
                        bit.append(value.substring(i, end + 1));
                        i = end;
                    } else {
                        bit.append(c);
                    }
                }
                if (i == length - 1) {
                    finishBit = true;
                    finishProp = true;
                }
                if (finishBit) {
                    String done = bit.toString();
                    if (buildingName) {
                        building.setName(done);
                        buildingName = false;
                    } else {
                        building.setTablePropertyValue(done);
                    }
                    bit = new StringBuilder();
                }
                if (!finishProp) continue;
                props.add(building);
                buildingName = true;
                building = new BigDataTableProperty();
            }
            if (!props.isEmpty()) {
                BigDataTableProperties frag = new BigDataTableProperties();
                for (BigDataTableProperty prop : props) {
                    frag.addBigDataTableProperty(prop);
                }
                param.setParameterValueFragment((SQLFragment)frag);
            }
        }
    }
}

