/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.XMLSchemaElement;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSchemaBuilder
extends OracleDBObjectBuilder<XMLSchema> {
    XMLSchemaBuilder(BaseOracleDatabase db) {
        super(db, "XML SCHEMA");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source", "internalName", "global", "qualifiedURL"})
    public void fillInPropreties(final XMLSchema xmlSchema) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)xmlSchema, "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_OBJECT_QUERY*/\n       sys.xmltype.getClobVal(SCHEMA), INT_OBJNAME, LOCAL, QUAL_SCHEMA_URL FROM SYS.ALL_XML_SCHEMAS WHERE OWNER = ? AND SCHEMA_URL = ? ", xmlSchema.getSchema(), xmlSchema);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        xmlSchema.setSource(rs.getString(1));
                        xmlSchema.setInternalName(rs.getString(2));
                        xmlSchema.setGlobal(!"YES".equals(rs.getString(3)));
                        xmlSchema.setQualifiedURL(rs.getString(4));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)xmlSchema, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"elements"})
    public void fillInElements(XMLSchema xmlSchema) throws DBException {
        ArrayList<XMLSchemaElement> elements = new ArrayList<XMLSchemaElement>();
        if (xmlSchema != null) {
            DOMParser parser = new DOMParser();
            String s = xmlSchema.getSource();
            XMLDocument doc = null;
            if (s != null) {
                StringReader sr = new StringReader(s);
                try {
                    parser.parse((Reader)sr);
                    doc = parser.getDocument();
                }
                catch (XMLParseException xMLParseException) {
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (doc != null) {
                Element rootNode = doc.getDocumentElement();
                NodeList nl = rootNode.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node attrNode;
                    Node child = nl.item(i);
                    String name = child.getLocalName();
                    if (name == null || !name.equals("element") && !name.endsWith(":element") || (attrNode = child.getAttributes().getNamedItem("name")) == null) continue;
                    String elementName = attrNode.getTextContent();
                    XMLSchemaElement element = new XMLSchemaElement();
                    NameBasedID id = new NameBasedID("XMLSchemaElement", elementName, xmlSchema.getID());
                    element.setName(elementName);
                    element.setID((DBObjectID)id);
                    elements.add(element);
                }
            }
        }
        xmlSchema.setElements(elements.toArray(new XMLSchemaElement[elements.size()]));
    }
}

