/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.Property;

public class OracleTablespaceUtil {
    public static DBObjectID getTablespaceID(DBObjectProvider prov, String tablespaceName) {
        ReferenceID id = null;
        try {
            Tablespace tbsp;
            if (prov != null && prov.supportsObjectType("TABLESPACE") && (tbsp = (Tablespace)prov.getObject(DBObjectCriteria.createSingleObjectCriteria((String)"TABLESPACE", (Schema)null, (String)tablespaceName))) != null) {
                id = tbsp.getID();
            }
            if (id == null) {
                id = new ReferenceID("TABLESPACE", (Schema)null, tablespaceName);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return id;
    }

    public static Map<String, Tablespace.TablespaceType> getTypeSpecificProperties() {
        HashMap<String, Tablespace.TablespaceType> retval = new HashMap<String, Tablespace.TablespaceType>();
        String base = "OracleTablespaceProperties";
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tablespaceGroup"}), Tablespace.TablespaceType.TEMPORARY);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"}), Tablespace.TablespaceType.UNDO);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "blockSize"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "forceLogging"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "segmentManagement"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"}), Tablespace.TablespaceType.PERMANENT);
        retval.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleInMemoryProperties"}), Tablespace.TablespaceType.PERMANENT);
        return retval;
    }
}

