/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class OracleSchemaBuilder
extends OracleDBObjectBuilder<Schema> {
    public OracleSchemaBuilder(BaseOracleDatabase db) {
        super(db, "SCHEMA");
    }

    private boolean shouldBuild(Schema schema) {
        return this.getDatabase() instanceof OracleDatabaseImpl && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getDatabase().getUserName());
    }

    protected boolean fillInObjectComponentImpl(Schema object, String prop) throws DBException {
        if (this.shouldBuild(object) && Thread.holdsLock(this.getDatabase().getConnection())) {
            String msg = "Deadlock risk: Connection locked before Schema property lock";
            DBLog.logIllegalState((String)"Deadlock risk: Connection locked before Schema property lock");
        }
        return super.fillInObjectComponentImpl((AbstractBuildableObject)object, prop);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleSchemaProperties"})
    public void fillInSchemaProperties(Schema schema) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_PRIVS"})
    public void fillInPrivs(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final TreeSet privs = new TreeSet();
            final QueryWrapper privsWrap = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDictionaryQueries.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SYS.SESSION_PRIVS");
            QueryWrapper.QueryRunnable privsRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            privs.add(rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        privsWrap.throwDBException(ex);
                    }
                }
            };
            try {
                privsWrap.executeQuery(privsRun);
            }
            catch (DBException dbe) {
                this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getDatabase().getConnectionName(), dbe.getMessage()}));
            }
            schema.setProperty("USER_PRIVS", (Object)privs.toArray(new String[privs.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_ROLES"})
    public void fillInRoles(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final TreeSet roles = new TreeSet();
            final QueryWrapper rolesWrap = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDictionaryQueries.ALL_ROLES_QUERY*/\n       ROLE FROM SYS.SESSION_ROLES");
            QueryWrapper.QueryRunnable rolesRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    block3: {
                        try {
                            while (rs.next()) {
                                roles.add(rs.getString(1));
                            }
                        }
                        catch (SQLException ex) {
                            if (OracleDictionaryQueries.isSaaS() && ex.getErrorCode() == 942) break block3;
                            rolesWrap.throwDBException(ex);
                        }
                    }
                }
            };
            try {
                rolesWrap.executeQuery(rolesRun);
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException dbe) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Could not load roles for database " + this.getDatabase().getConnectionName(), dbe.getCause() == null ? dbe : dbe.getCause());
            }
            schema.setProperty("USER_ROLES", (Object)roles.toArray(new String[roles.size()]));
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

