/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.SQLException;
import java.util.List;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.util.Holder;

class OracleQueryWrapper
extends QueryWrapper {
    private final Holder<Boolean> m_queryChecked = new Holder((Object)false);

    public OracleQueryWrapper(BaseOracleDatabase db, String query, Object ... params) {
        super((Database)db, query, params);
    }

    public OracleQueryWrapper(BaseOracleDatabase db, String query, List params) {
        super((Database)db, query, params);
    }

    public void executeQuery(int fetchSize, QueryWrapper.QueryRunnable run) throws DBException {
        this.getQuery();
        super.executeQuery(fetchSize, run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getQuery() {
        Holder<Boolean> holder = this.m_queryChecked;
        synchronized (holder) {
            if (!((Boolean)this.m_queryChecked.get()).booleanValue()) {
                String[] stmts = this.getStatementStrings();
                for (int i = 0; i < stmts.length; ++i) {
                    stmts[i] = this.checkQuery(stmts[i]);
                }
                this.setStatement(stmts);
                this.m_queryChecked.set((Object)true);
            }
        }
        return super.getQuery();
    }

    private String checkQuery(String query) {
        OracleDictionaryQueries dict = ((BaseOracleDatabase)this.getDatabase()).getDictionaryQueries();
        String ret = query;
        ret = this.getDatabaseName() != null ? ret.replaceAll("(SYS\\.[A-Z0-9_.]*)", "$1@" + this.getDatabaseName()) : dict.getQuery(ret);
        return ret;
    }

    protected boolean hasCancelled(SQLException sqe) {
        return super.hasCancelled(sqe) || sqe.getErrorCode() == 1013;
    }
}

