/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleIndexBuilder
extends OracleDBObjectBuilder<Index> {
    public OracleIndexBuilder(BaseOracleDatabase db) {
        super(db, "INDEX");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"table"})
    public void fillInTable(Index index) throws DBException {
        this.checkParentAndCacheIndex(index, true);
    }

    private Table checkParentAndCacheIndex(Index index, boolean force) throws DBException {
        Table retval = null;
        DBObject existingParent = index.getParent();
        if (existingParent == null || force) {
            SchemaObject parent = this.getParent(index);
            BaseOracleDatabase db = this.getDatabase();
            Index cached = (Index)this.findObjectInProviderCache("INDEX", index.getSchema(), index.getName());
            if (cached != index) {
                if (cached != null) {
                    this.getLogger().log(Level.WARNING, "build requested on index {0} but provider has a different version cached.", index.getName());
                }
                db.cacheObject((SystemObject)index, false);
            }
            if (parent instanceof Table) {
                if (existingParent != null && existingParent != parent) {
                    this.getLogger().log(Level.WARNING, "build requested on index {0} but its parent doesn't match the provider cache.", index.getName());
                }
                retval = (Table)parent;
                index.setTable(retval);
            }
        } else if (existingParent instanceof Table) {
            retval = (Table)existingParent;
        }
        return retval;
    }

    private SchemaObject getParent(final Index index) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)index, this.getIndexTabQuery(), index.getSchema(), index);
        final String[] details = new String[3];
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        details[0] = rs.getString(1);
                        details[1] = rs.getString(2);
                        details[2] = rs.getString(3);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)index, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        String tabName = details[0];
        String tabOwner = details[1];
        String tabType = details[2];
        if (ModelUtil.hasLength((String)tabOwner) && ModelUtil.hasLength((String)tabName) && ModelUtil.hasLength((String)tabType)) {
            BaseOracleDatabase db = this.getDatabase();
            Schema s = this.getSchema(tabOwner);
            if (s != null) {
                SchemaObject obj = db.getObject(tabType, s, tabName);
                if (obj == null && "TABLE".equals(tabType)) {
                    obj = db.getObject("MATERIALIZED VIEW", s, tabName);
                }
                return obj;
            }
        }
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"systemGenerated"}, depends={"table", "columnExpressions"})
    public void fillInSystemGenerated(Index index) throws DBException {
        Constraint c;
        Table parent = this.checkParentAndCacheIndex(index, false);
        final Holder res = new Holder();
        boolean sysgen = false;
        UniqueConstraint uk = ConstraintIndexHelper.forConstraint(index);
        if (uk != null) {
            sysgen = uk.getName().equals(index.getName());
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)parent, "SELECT /*OracleDictionaryQueries.ALL_INDEX_METADATA_QUERY*/\n       SYS.DBMS_METADATA.GET_XML('INDEX', ?, ?) XML\nFROM   SYS.DUAL", index, parent.getSchema());
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            res.set((Object)rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            };
            wrap.executeQuery(r);
            try {
                NodeList list;
                if (ModelUtil.hasLength((String)((String)res.get()))) {
                    DOMParser parser = new DOMParser();
                    StringReader reader = new StringReader((String)res.get());
                    parser.parse((Reader)reader);
                    XMLDocument doc = parser.getDocument();
                    list = doc.selectNodes("/ROWSET/ROW/INDEX_T/PROPERTY");
                    if (list.getLength() != 1) {
                        throw new RuntimeException("1 node expected at /ROWSET/ROW/INDEX_T/PROPERTY - got " + list.getLength());
                    }
                } else {
                    throw new RuntimeException("Nothing returned from dbms_metadat.get_xml");
                }
                Node node = list.item(0);
                String text = node.getTextContent();
                Integer indexProps = Integer.valueOf(text);
                sysgen = (indexProps & 0x1000) == 4096;
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to find the property of index " + index.getName(), e);
            }
        } else if (uk == null && this.getDatabase() instanceof OracleLite && (c = parent.getConstraint(index.getName())) instanceof UniqueConstraint && ConstraintIndexHelper.indexValidForConstraint(index, (UniqueConstraint)c, (DBObjectProvider)this.getDatabase())) {
            sysgen = true;
        }
        index.setSystemGenerated(Boolean.valueOf(sysgen));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexType", "domainIndextype", "domainIndextypeOpStatus", "domainIndextypeParameters", "OracleStorageProperties", "parallelDegree", "keyCompression", "reverse", "columnExpressions"}, depends={"table"})
    public void fillInBaseProperties(Index index) throws DBException {
        Table table = this.checkParentAndCacheIndex(index, false);
        if (table != null) {
            OracleTableBuilder builder = (OracleTableBuilder)this.getDatabase().getBuilderForType("TABLE");
            builder.fillInIndexes(table);
        }
    }

    void fillInIndexes(MaterializedView mview, String usingIndexName) throws DBException {
        this.fillInIndexesImpl((Table)mview, usingIndexName);
    }

    void fillInIndexes(Table parent) throws DBException {
        this.fillInIndexesImpl(parent, null);
    }

    private void fillInIndexesImpl(final Table parent, String usingIndexName) throws DBException {
        final TreeMap<String, Index> indexes = new TreeMap<String, Index>();
        String query = this.getTableIndexesQuery();
        String parentType = parent.getType();
        if (parent instanceof MaterializedView) {
            parentType = "TABLE";
        }
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)parent, query, parent.getSchema(), parentType, parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        Table.TableType tt;
                        Index resolved;
                        DBObjectID id;
                        String idxName = rs.getString(1);
                        String owner = rs.getString(2);
                        BigDecimal idInt = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            idInt = null;
                        }
                        String uniqueness = rs.getString(4);
                        String indexTypeString = rs.getString(5);
                        String itypOwner = rs.getString(6);
                        String itypName = rs.getString(7);
                        String itypParameters = rs.getString(8);
                        String domIdxOpStatus = rs.getString(9);
                        String degree = rs.getString(10);
                        String prefix_length = rs.getString(11);
                        Schema s = OracleIndexBuilder.this.getSchema(owner);
                        BaseOracleDatabase db = OracleIndexBuilder.this.getDatabase();
                        Index index = null;
                        if (idInt != null) {
                            index = (Index)OracleIndexBuilder.this.findObjectInProviderCache((DBObjectID)new IdentifierBasedID("INDEX", (Object)idInt));
                        }
                        if (index == null) {
                            index = (Index)OracleIndexBuilder.this.findObjectInProviderCache("INDEX", s, idxName);
                        }
                        if (index != null && (id = index.getID()) != null && (resolved = (Index)id.resolveID()) == null) {
                            index = null;
                        }
                        if (index == null) {
                            id = db.createID(null, s, idxName, "INDEX", idInt);
                            index = (Index)OracleIndexBuilder.this.createObject(idxName, s, id);
                            db.cacheObject((SystemObject)index, true);
                            db.setOracleBuilder(index, OracleIndexBuilder.this);
                        }
                        if (index == null) continue;
                        if (parent != null) {
                            DBObjectID parID = parent.getID();
                            DBObjectID idxID = index.getID();
                            if (idxID instanceof BaseObjectID && parID != null && !parID.equals(idxID.getParent(), true)) {
                                ((BaseObjectID)idxID).setParent(parID);
                                index.setID(idxID);
                            }
                        }
                        Object type = null;
                        ReferenceID domainIndextype = null;
                        String domainIndextypeParameters = null;
                        String domainIndextypeOpStatus = null;
                        if (Index.IndexType.UNIQUE.toString().equals(uniqueness)) {
                            type = Index.IndexType.UNIQUE;
                        } else if (indexTypeString != null && Index.IndexType.DOMAIN.equals(type = indexTypeString.contains(Index.IndexType.NORMAL.toString()) ? Index.IndexType.NORMAL : (indexTypeString.contains(Index.IndexType.BITMAP.toString()) ? Index.IndexType.BITMAP : (indexTypeString.equals(Index.IndexType.DOMAIN.toString()) ? Index.IndexType.DOMAIN : null)))) {
                            domainIndextype = new ReferenceID("INDEXTYPE", itypOwner, itypName);
                            domainIndextypeParameters = itypParameters;
                            domainIndextypeOpStatus = domIdxOpStatus;
                        }
                        if (indexTypeString != null) {
                            if (indexTypeString.endsWith("/REV")) {
                                index.setReverse(Boolean.valueOf(true));
                            } else if (type.equals((Object)Index.IndexType.NORMAL) || type.equals((Object)Index.IndexType.UNIQUE)) {
                                index.setReverse(Boolean.valueOf(false));
                            } else {
                                index.setReverse(null);
                            }
                        }
                        index.setIndexType(type);
                        index.setDomainIndextype(domainIndextype);
                        index.setDomainIndextypeParameters(domainIndextypeParameters);
                        index.setDomainIndextypeOpStatus(domainIndextypeOpStatus);
                        Integer parallelDegree = null;
                        if (ModelUtil.hasLength((String)degree)) {
                            parallelDegree = "DEFAULT".equals(degree) ? 0 : Integer.decode(degree);
                        }
                        index.setParallelDegree(parallelDegree);
                        if (ModelUtil.hasLength((String)prefix_length)) {
                            index.setKeyCompression(Integer.valueOf(prefix_length));
                        } else {
                            index.setKeyCompression(null);
                        }
                        boolean tempTable = "TABLE".equals(parent.getType()) ? (tt = (Table.TableType)parent.getProperty("TableType")) == Table.TableType.SESSION_TEMP || tt == Table.TableType.TRANSACTION_TEMP : false;
                        OracleStorageProperties osp = null;
                        if (!tempTable) {
                            osp = OracleTableBuilder.getSegmentAttributeProperties(rs, db);
                        }
                        index.setProperty("OracleStorageProperties", (Object)osp);
                        index.setTable(parent);
                        indexes.put(idxName, index);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)parent, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        this.fillInExpressionsForTable(parent, indexes);
        ArrayList<Index> idxList = new ArrayList<Index>(indexes.values());
        this.removeSystemIndexes((Relation)parent, idxList, usingIndexName);
        Index[] idxArray = idxList.toArray(new Index[idxList.size()]);
        parent.setIndexes(idxArray);
        for (Index idx : indexes.values()) {
            this.registerObject((AbstractBuildableObject)idx);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleIndexPartitions"}, depends={"table", "columnExpressions"})
    public void fillInPartitions(final Index index) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        if (db.supportsPartitioning()) {
            final Table table = this.checkParentAndCacheIndex(index, false);
            String indexName = index.getName();
            final QueryWrapper wrap = db.newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_TYPE_QUERY*/\n       partitioning_type, subpartitioning_type, locality, partition_count\nfrom   sys.all_part_indexes api\nwhere  api.owner = ?\nand    api.index_name = ?\n", index.getSchema(), indexName);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String partitioningType = rs.getString("PARTITIONING_TYPE");
                            String subpartitioningType = rs.getString("SUBPARTITIONING_TYPE");
                            String locality = rs.getString("LOCALITY");
                            String partitionCount = rs.getString("PARTITION_COUNT");
                            if ("SYSTEM".equals(partitioningType)) {
                                return;
                            }
                            OracleIndexPartitions oip = (OracleIndexPartitions)OracleIndexBuilder.this.newObject(OracleIndexPartitions.class, null);
                            index.setProperty("OracleIndexPartitions", (Object)oip);
                            NameBasedID id = new NameBasedID((DBObject)oip, index.getID());
                            oip.setID((DBObjectID)id);
                            OracleIndexPartitions.PartitionType partitionType = "GLOBAL".equals(locality) ? OracleIndexPartitions.PartitionType.valueOf((String)(locality + '_' + partitioningType)) : ("HASH".equals(partitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_HASH : ("NONE".equals(subpartitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_OTHER : OracleIndexPartitions.PartitionType.LOCAL_COMP));
                            oip.setPartitionType(partitionType);
                            if ("GLOBAL".equals(locality)) {
                                oip.setGlobalPartitionColumns(OracleIndexBuilder.this.getGlobalPartitionColumns(index));
                                Integer guantity = partitionCount != null || partitionCount != "" ? Integer.decode(partitionCount) : 0;
                                if ("HASH".equals(partitioningType) && guantity > 0 && index.getName().startsWith("SYS_P")) {
                                    oip.setGlobalHashQuantity(guantity);
                                }
                            }
                            OracleIndexBuilder.this.fillInIndexPartitions(index);
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException((DBObject)table, ex);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    private DBObjectID[] getGlobalPartitionColumns(Index index) throws DBException {
        final ArrayList columnIDs = new ArrayList();
        final Table table = index.getTable();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_COLUMNS_QUERY*/\n       column_name\nfrom   sys.all_part_key_columns apk1\nwhere  apk1.owner = ?\nand    apk1.name = ?\nand    apk1.object_type = 'INDEX'\norder by apk1.column_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String columnName = rs.getString(1);
                        columnIDs.add(new NameBasedID("COLUMN", columnName, table.getID()));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)table, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return columnIDs.toArray(new DBObjectID[columnIDs.size()]);
    }

    private void fillInIndexPartitions(final Index index) throws DBException {
        final OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        final OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        final Map<String, OracleIndexPartitions> subpartitionsMap = partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP ? this.getSubpartitions(index) : null;
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   sys.all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String name = rs.getString("PARTITION_NAME");
                        IndexPartition ip = new IndexPartition(name, oip);
                        oip.addPartition(ip);
                        NameBasedID id = new NameBasedID((DBObject)ip, oip.getID());
                        ip.setID((DBObjectID)id);
                        if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                            String compression = rs.getString("COMPRESSION");
                            Boolean keyCompression = rs.wasNull() || !ModelUtil.hasLength((String)compression) ? null : Boolean.valueOf("ENABLED".equals(compression));
                            ip.setUseKeyCompression(keyCompression);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                            String highValue = rs.getString("HIGH_VALUE");
                            ip.setValuesLessThan(highValue);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                            String tablespaceName = rs.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)tablespaceName)) {
                                OracleStorageProperties osp = new OracleStorageProperties();
                                ip.setSegmentAttributes(osp);
                                osp.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), tablespaceName));
                            }
                        } else if (index.getIndexType() == Index.IndexType.DOMAIN) {
                            ip.setDomainParameters(rs.getString("PARAMETERS"));
                        } else {
                            ip.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs, OracleIndexBuilder.this.getDatabase()));
                        }
                        if (subpartitionsMap == null || !subpartitionsMap.containsKey(name)) continue;
                        ip.setSubpartitions((OracleIndexPartitions)subpartitionsMap.get(name));
                        OracleIndexBuilder.this.setSubpartitionIDs(ip);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)index, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private Map<String, OracleIndexPartitions> getSubpartitions(final Index index) throws DBException {
        final HashMap<String, OracleIndexPartitions> map = new HashMap<String, OracleIndexPartitions>();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_IND_SUBPARTITIONS\nwhere  INDEX_OWNER = ?\nand    INDEX_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", index.getSchema(), index);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                String currentPartitionName = null;
                OracleIndexPartitions subpartitions = null;
                try {
                    while (rs.next()) {
                        String name = rs.getString("PARTITION_NAME");
                        if (!name.equals(currentPartitionName)) {
                            subpartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                            map.put(name, subpartitions);
                            currentPartitionName = name;
                        }
                        IndexPartition sp = new IndexPartition(rs.getString("SUBPARTITION_NAME"), subpartitions);
                        subpartitions.addPartition(sp);
                        name = rs.getString("TABLESPACE_NAME");
                        if (!ModelUtil.hasLength((String)name)) continue;
                        OracleStorageProperties osp = new OracleStorageProperties();
                        sp.setSegmentAttributes(osp);
                        osp.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), name));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)index, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return map;
    }

    private void setSubpartitionIDs(IndexPartition ip) {
        OracleIndexPartitions subpartitions = ip.getSubpartitions();
        if (subpartitions != null) {
            NameBasedID parid = new NameBasedID((DBObject)subpartitions, ip.getID());
            subpartitions.setID((DBObjectID)parid);
            for (IndexPartition sp : subpartitions.getPartitions()) {
                sp.setID((DBObjectID)new NameBasedID((DBObject)sp, (DBObjectID)parid));
            }
        }
    }

    private void fillInExpressionsForTable(final Table parent, Map<String, Index> indexes) throws DBException {
        final MultiMap indexCols = new MultiMap();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)parent, this.getIndexColumnQuery(), parent.getSchema(), parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        IndexColumnQueryResult result = new IndexColumnQueryResult(rs);
                        indexCols.add((Object)result.idxName, (Object)result);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)parent, ex);
                }
            }
        };
        wrap.executeQuery(r);
        Map<String, Map<Long, String>> idxExpressions = null;
        for (Map.Entry entry : indexCols.entrySet()) {
            Index index = indexes.get(entry.getKey());
            if (index == null) continue;
            Collection result = (Collection)entry.getValue();
            IndexObject[] expressions = new IndexObject[result.size()];
            int i = 0;
            for (IndexColumnQueryResult stuff : result) {
                String idxName = stuff.idxName;
                String colName = stuff.colName;
                Long colPosn = stuff.colPosn;
                String colDesc = stuff.colDesc;
                String expression = null;
                if (stuff.isAllIndExp == 1) {
                    Map columnMap;
                    if (idxExpressions == null) {
                        idxExpressions = this.getIndexExpressionsForTable((SchemaObject)parent);
                    }
                    if ((columnMap = (Map)idxExpressions.get(idxName)) == null || !columnMap.containsKey(colPosn)) {
                        this.getLogger().warning("Missing column expression");
                    } else {
                        expression = (String)columnMap.get(colPosn);
                    }
                } else {
                    expression = this.getDatabase().getExternalName(colName);
                }
                if (index.getIndexType() == Index.IndexType.DOMAIN) {
                    colDesc = null;
                }
                IndexObject.OrderType orderType = null;
                if (colDesc != null) {
                    orderType = IndexObject.OrderType.valueOf((String)colDesc);
                }
                IndexObject io = (IndexObject)this.newObject(IndexObject.class, null);
                io.setExpressionSource(expression);
                io.setOrderType(orderType);
                expressions[i++] = io;
            }
            index.setColumnExpressions(expressions);
        }
    }

    private Map<String, Map<Long, String>> getIndexExpressionsForTable(final SchemaObject parent) throws DBException {
        final HashMap<String, Map<Long, String>> idxExpressions = new HashMap<String, Map<Long, String>>();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)parent, "SELECT /*OracleDictionaryQueries.ALL_INDEX_EXPRESSION_PER_TAB_QUERY*/\n       index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ", parent.getSchema(), parent);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String idxName = rs.getString(1);
                        Long colPosn = new Long(rs.getInt(2));
                        String colExpr = rs.getString(3);
                        HashMap<Long, String> columnMap = (HashMap<Long, String>)idxExpressions.get(idxName);
                        if (columnMap == null) {
                            columnMap = new HashMap<Long, String>();
                            idxExpressions.put(idxName, columnMap);
                        }
                        columnMap.put(colPosn, colExpr);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)parent, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return idxExpressions;
    }

    public static SQLFragment createExpression(String exp, Relation parent, DBObjectProvider pro) {
        return SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)pro, (Relation)parent, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)exp);
    }

    private String getIndexTabQuery() {
        String databaseType = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(databaseType) ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?";
    }

    private String getIndexColumnQuery() {
        String databaseType = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(databaseType) ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_COLUMN_PER_TAB_QUERY*/\n       INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_COLUMN_PER_TAB_QUERY*/\n       c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    }

    private String getTableIndexesQuery() {
        String databaseType = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(databaseType) ? " SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, 'NORMAL', null, null, null, null, null, null,        null TABLESPACE_NAME, null PCT_FREE, null PCT_USED, null INI_TRANS, null MAX_TRANS,\n       null INITIAL_EXTENT, null NEXT_EXTENT, null MIN_EXTENTS, null MAX_EXTENTS, null PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING, null BUFFER_POOL\n FROM SYS.ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER,       (select object_id from sys.all_objects where object_name = i.index_name and owner = i.owner and object_type = 'INDEX') OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\nFROM SYS.ALL_INDEXES i WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND INDEX_TYPE != 'LOB'";
    }

    private void removeSystemIndexes(Relation parent, Collection<Index> indexes, String usingIndexName) throws DBException {
        Iterator<Index> idxIter = indexes.iterator();
        while (idxIter.hasNext()) {
            Index index = idxIter.next();
            if (parent instanceof MaterializedView && usingIndexName != null && index.getName().equals(usingIndexName)) {
                idxIter.remove();
                continue;
            }
            if (!index.getName().startsWith("SYS_C")) continue;
            boolean remove = false;
            IndexObject[] expressions = index.getColumnExpressions();
            if (expressions.length == 1) {
                String expr = expressions[0].getExpressionSource();
                Column col = parent.getColumn(expr);
                if (col != null) {
                    if (col.getDataTypeUsage() != null && col.getDataTypeUsage().getDataTypeID() != null) {
                        DBObject type = null;
                        try {
                            type = col.getDataTypeUsage().getDataTypeID().resolveID();
                            if (type instanceof Type) {
                                remove = true;
                            }
                        }
                        catch (DBException dbe) {
                            this.getLogger().warning(dbe.getMessage());
                        }
                    }
                } else if (this.getDatabase().getDatabaseVersion() <= 92 && expr.startsWith("SYS_NC")) {
                    remove = true;
                }
            }
            if (remove) {
                idxIter.remove();
                continue;
            }
            this.getLogger().fine("Keeping index " + index.getName() + " on " + parent.getName());
        }
    }

    private class IndexColumnQueryResult {
        String idxName;
        String colName;
        Long colPosn;
        String colDesc;
        int isAllIndExp;

        private IndexColumnQueryResult(ResultSet rs) throws SQLException {
            this.idxName = rs.getString(1);
            this.colName = rs.getString(2);
            this.colPosn = new Long(rs.getInt(3));
            this.colDesc = rs.getString(4);
            this.isAllIndExp = rs.getInt(5);
        }

        public String toString() {
            return "\n" + this.idxName + " " + this.colName + " " + this.colPosn + " " + this.colDesc + " " + this.isAllIndExp + "\n";
        }
    }
}

