/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.DatabaseLinkBuilder;
import oracle.javatools.db.ora.JavaBinaryBuilder;
import oracle.javatools.db.ora.JavaSourceBuilder;
import oracle.javatools.db.ora.MaterializedViewBuilder;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;

public class Oracle8i
extends Oracle8 {
    private static final String DBA = "DBA";
    private static final String CREATE_PRIV = "CREATE {0}";
    private static final String CREATE_ANY_PRIV = "CREATE ANY {0}";
    private static final String CREATE_PUBLIC_PRIV = "CREATE PUBLIC {0}";
    private static final String ALTER_ANY_PRIV = "ALTER ANY {0}";
    private static final String ALTER_PUBLIC_PRIV = "ALTER PUBLIC {0}";
    private static final String ALTER_PRIV = "ALTER {0}";
    private static final String DROP_ANY_PRIV = "DROP ANY {0}";
    private static final String DROP_PUBLIC_PRIV = "DROP PUBLIC {0}";

    Oracle8i(String connStore, String connName, Connection conn, int version) {
        super(connStore, connName, conn, version);
        if (conn instanceof OracleConnection) {
            Oracle8i.initOC((OracleConnection)conn);
        }
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        if (this.supportsJava()) {
            this.registerBuilder("JAVA SOURCE", (DBObjectBuilder)new JavaSourceBuilder(this));
            this.registerBuilder("JAVA CLASS", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA CLASS"));
            this.registerBuilder("JAVA RESOURCE", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA RESOURCE"));
        }
        this.registerBuilder("MATERIALIZED VIEW", (DBObjectBuilder)new MaterializedViewBuilder(this));
        this.registerBuilder("MATERIALIZED VIEW LOG", (DBObjectBuilder)new MaterializedViewLogBuilder(this));
        this.registerBuilder("DATABASE LINK", (DBObjectBuilder)new DatabaseLinkBuilder(this));
    }

    @Override
    public boolean supportsJava() {
        return true;
    }

    @Override
    public boolean hasSystemPrivilege(String type, Schema schema, String priv) {
        String dbType = type;
        if ("MATERIALIZED VIEW".equals(type) && this.getDatabaseVersion() < 100) {
            dbType = "SNAPSHOT";
        } else if ("PACKAGE".equals(type) || "PACKAGE BODY".equals(type) || "FUNCTION".equals(type)) {
            dbType = "PROCEDURE";
        } else if ("TYPE BODY".equals(type)) {
            dbType = "TYPE";
        } else if ("MATERIALIZED VIEW LOG".equals(type)) {
            dbType = "TABLE";
        } else if ("SCHEMA".equals(type)) {
            dbType = "USER";
        }
        if (DBObjectRegistry.isExtensionType((String)dbType, (String)"Oracle Database", (int)this.getDatabaseVersion())) {
            return true;
        }
        Object[] args = new Object[]{dbType};
        if (ModelUtil.areEqual((Object)"CREATE", (Object)priv)) {
            if ("INDEX".equals(type) && (schema == null || this.isCurrentUser(schema))) {
                return true;
            }
            if ("XML SCHEMA".equals(type)) {
                return true;
            }
            boolean can = this.hasPrivilege(MessageFormat.format(CREATE_ANY_PRIV, args));
            if (!can) {
                if (schema == null || this.isCurrentUser(schema)) {
                    can = this.hasPrivilege(MessageFormat.format(CREATE_PRIV, args));
                } else if (schema != null && this.isPublicSchema(schema)) {
                    can = this.hasPrivilege(MessageFormat.format(CREATE_PUBLIC_PRIV, args));
                }
            }
            return can;
        }
        if (ModelUtil.areEqual((Object)"MODIFY", (Object)priv)) {
            boolean can;
            if (Metadata.getInstance().isSchemaObject(type)) {
                can = this.isCurrentUser(schema) ? true : (this.getPropertyManager().supportsAction(type, PropertyAction.Type.ALTER) ? this.hasPrivilege(MessageFormat.format(this.isPublicSchema(schema) ? ALTER_PUBLIC_PRIV : ALTER_ANY_PRIV, args)) : this.hasSystemPrivilege(type, schema, "DELETE") && this.hasSystemPrivilege(type, schema, "CREATE"));
            } else {
                can = this.hasPrivilege(MessageFormat.format(ALTER_PRIV, args));
                if (can && "TABLESPACE".equals(type)) {
                    can = this.hasRole(DBA);
                }
            }
            return can;
        }
        if (ModelUtil.areEqual((Object)"DELETE", (Object)priv)) {
            if ("SCHEMA".equals(type)) {
                return !this.isCurrentUser(schema) && !this.isPublicSchema(schema) && this.hasPrivilege("DROP USER");
            }
            if ("TABLESPACE".equals(type)) {
                return this.hasPrivilege("DROP TABLESPACE");
            }
            boolean can = true;
            if (!this.isCurrentUser(schema)) {
                can = false;
                if (this.isPublicSchema(schema)) {
                    can = this.hasPrivilege(MessageFormat.format(DROP_PUBLIC_PRIV, args));
                }
                if (!can) {
                    can = this.hasPrivilege(MessageFormat.format(DROP_ANY_PRIV, args));
                }
            }
            return can;
        }
        return super.hasSystemPrivilege(type, schema, priv);
    }

    static void initOC(OracleConnection oc) {
        if (oc.getSessionTimeZone() == null) {
            boolean tzSet = false;
            TimeZone tz = TimeZone.getDefault();
            String tzName = tz != null ? tz.getID() : "America/Los_Angeles";
            try {
                oc.setSessionTimeZone(tzName);
                tzSet = true;
            }
            catch (SQLException sQLException) {
            }
            catch (IllegalArgumentException ex) {
                tzSet = true;
            }
            if (!tzSet) {
                Calendar c = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
                int offset = c.get(16) + c.get(15);
                int minutes = offset / 60000;
                String fmt = MessageFormat.format("{0,number,00}:{1,number,00}", new Integer(minutes / 60), new Integer(minutes % 60));
                try {
                    oc.setSessionTimeZone(fmt);
                }
                catch (SQLException ex) {
                    DBLog.getLogger(Oracle8i.class).log(Level.WARNING, "Error setting Session TimeZone to either {0} or {1}: {2}", new Object[]{tzName, fmt, ex.getMessage()});
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

