/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;

public class LocalIndexPartitionHelper {
    public static Collection<OracleIndexPartitions> getLocalIndexPartitionModels(Table table) {
        Index[] indexes = table.getIndexes();
        ArrayList<OracleIndexPartitions> oips = new ArrayList<OracleIndexPartitions>();
        for (Index index : indexes) {
            OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
            if (!LocalIndexPartitionHelper.isPartitionedLocally(oip)) continue;
            oips.add(oip);
        }
        return oips;
    }

    public static boolean isPartitionedLocally(OracleIndexPartitions oip) {
        return oip != null && (oip.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_COMP || oip.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_HASH || oip.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_OTHER);
    }

    public static IndexPartition createLocalIndexPartition(TablePartition tp, String name) {
        IndexPartition ip;
        block6: {
            int numOfSubParts;
            OracleIndexPartitions suboip;
            block8: {
                TablePartition[] subpartitions;
                block7: {
                    ip = new IndexPartition();
                    ip.setName(name);
                    if (tp == null) break block6;
                    OracleTablePartitions parts = (OracleTablePartitions)tp.getParent();
                    OracleTablePartitions subPartsModel = parts.getSubpartitionModel();
                    suboip = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                    OracleTablePartitions subparts = tp.getPartitionLevelSubpartitions();
                    numOfSubParts = 0;
                    if (subPartsModel == null) break block6;
                    if (subparts == null) {
                        subparts = subPartsModel;
                    }
                    if ((subpartitions = subparts.getPartitions()).length != 0) break block7;
                    numOfSubParts = 1;
                    if (subparts.getPartitionType() != OracleTablePartitions.PartitionType.HASH) break block8;
                    Object hashQuantity = subparts.getHashQuantity();
                    if (hashQuantity == null) {
                        hashQuantity = subPartsModel.getHashQuantity();
                    }
                    if (hashQuantity == null || (Integer)hashQuantity <= 0) break block8;
                    numOfSubParts = (Integer)hashQuantity;
                    break block8;
                }
                for (TablePartition subpart : subpartitions) {
                    String partitionName = ip.getName() + "_" + subpart.getName();
                    if (subpart.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                        partitionName = subpart.getName();
                    }
                    suboip.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, partitionName));
                }
            }
            if (numOfSubParts > 0) {
                for (int i = 1; i <= numOfSubParts; ++i) {
                    suboip.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, name + "_" + "SUBPARTITION" + i));
                }
            }
            ip.setSubpartitions(suboip);
        }
        return ip;
    }

    public static TablePartition getBaseTablePartition(IndexPartition ip) {
        TablePartition tp = null;
        OracleIndexPartitions oip = (OracleIndexPartitions)ip.getParent();
        DBObject partsParent = oip.getParent();
        Index index = null;
        if (partsParent instanceof Index) {
            index = (Index)partsParent;
            tp = LocalIndexPartitionHelper.getCorrespondingTablePartition(ip, index, null);
        } else {
            IndexPartition parentIp;
            TablePartition parentTp;
            index = (Index)DBUtil.findParentOfType((DBObject)ip, Index.class);
            if (index != null && (tp = LocalIndexPartitionHelper.getCorrespondingTablePartition(ip, index, parentTp = LocalIndexPartitionHelper.getCorrespondingTablePartition(parentIp = (IndexPartition)ip.getParent().getParent(), index, null))) != null && tp.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                TablePartition augmentedTp = new TablePartition();
                tp.copyTo((Object)augmentedTp);
                augmentedTp.setName(parentTp.getName() + "_" + tp.getName());
                tp = augmentedTp;
            }
        }
        return tp;
    }

    private static TablePartition getCorrespondingTablePartition(IndexPartition ip, Index index, TablePartition parentPartition) {
        TablePartition tp = null;
        OracleIndexPartitions oip = (OracleIndexPartitions)ip.getParent();
        IndexPartition[] ips = oip.getPartitions();
        for (int i = 0; i < ips.length; ++i) {
            IndexPartition indPart = ips[i];
            if (!ModelUtil.areEqual((Object)ip.getName(), (Object)indPart.getName())) continue;
            TablePartition[] tableParts = LocalIndexPartitionHelper.getCorrespondingTablePartitions(parentPartition, index);
            if (i >= tableParts.length) break;
            tp = tableParts[i];
            break;
        }
        return tp;
    }

    private static TablePartition[] getCorrespondingTablePartitions(TablePartition tp, Index index) {
        TablePartition[] partitions = new TablePartition[]{};
        if (tp == null) {
            Table table = (Table)DBUtil.findParentOfType((DBObject)index, Table.class);
            OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (otp != null) {
                partitions = otp.getPartitions();
            }
        } else {
            OracleTablePartitions parts = (OracleTablePartitions)tp.getParent();
            OracleTablePartitions subPartsModel = parts.getSubpartitionModel();
            OracleTablePartitions subparts = tp.getPartitionLevelSubpartitions();
            if (subPartsModel != null) {
                if (subparts == null) {
                    subparts = subPartsModel;
                }
                partitions = subparts.getPartitions();
            }
        }
        return partitions;
    }

    public static boolean areTableAndIndexPartitionsSameShape(OracleTablePartitions otp, OracleIndexPartitions oip) {
        boolean areSame = true;
        TablePartition[] tablePartitions = otp.getPartitions();
        IndexPartition[] indexPartitions = oip.getPartitions();
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            int numParts = tablePartitions.length;
            if (numParts == 0) {
                Integer hashQuant = otp.getHashQuantity();
                int n = numParts = hashQuant != null ? hashQuant : 1;
            }
            if (numParts != indexPartitions.length) {
                areSame = false;
            }
        } else if (tablePartitions.length == indexPartitions.length) {
            for (int i = 0; i < tablePartitions.length; ++i) {
                TablePartition tp = tablePartitions[i];
                IndexPartition ip = indexPartitions[i];
                int tpSubsCount = ReferencePartitionHelper.getSubPartitionsCount(tp);
                int ipSubsCount = 0;
                OracleIndexPartitions subOip = ip.getSubpartitions();
                if (subOip != null) {
                    ipSubsCount = subOip.getPartitions().length;
                }
                if (tpSubsCount == ipSubsCount) continue;
                areSame = false;
                break;
            }
        } else {
            areSame = false;
        }
        return areSame;
    }

    public static void cascadeTablePartitions(SystemObject sysObj, OracleTablePartitions origParts, OracleTablePartitions updParts, Database db) throws DBException {
        DBObjectValidator validator = ((AbstractDBObjectProvider)db).getValidatorForType("TABLE");
        Difference objDiff = db.getDiffEngine().difference((Object)origParts, (Object)updParts);
        boolean hasSubParts = updParts.getSubpartitionModel() != null;
        objDiff.setSame(false);
        Difference partitionDiff = objDiff.getChildDifference("partitions");
        if (partitionDiff != null) {
            Collection partitionDiffs = partitionDiff.getChildren();
            for (Difference diff : partitionDiffs) {
                Difference subpartitionsDiff;
                Difference subpartsDiff;
                int origi = diff.getIndexOfOriginalObject();
                int updi = diff.getIndexOfUpdatedObject();
                TablePartition updPart = (TablePartition)diff.getUpdatedObject();
                if (diff.isSame() || origi != updi) continue;
                Difference nameChange = diff.getChildDifference("name", true);
                if (nameChange != null) {
                    if (TemporaryObjectID.getOriginalObject((DBObject)updPart) == null) continue;
                    diff.setSame(true);
                    continue;
                }
                if (!hasSubParts || (subpartsDiff = diff.getChildDifference("partitionLevelSubpartitions")) == null || (subpartitionsDiff = subpartsDiff.getChildDifference("partitions")) == null || subpartitionsDiff.isSame()) continue;
                for (Difference subDiff : subpartitionsDiff.getChildren()) {
                    Difference subNameChange;
                    int origSubi = subDiff.getIndexOfOriginalObject();
                    int updSubi = subDiff.getIndexOfUpdatedObject();
                    TablePartition updSubPart = (TablePartition)subDiff.getUpdatedObject();
                    if (origSubi != updSubi || subDiff.isSame() || (subNameChange = subDiff.getChildDifference("name", true)) == null || TemporaryObjectID.getOriginalObject((DBObject)updSubPart) == null) continue;
                    subDiff.setSame(true);
                }
            }
        }
        validator.cascadeUpdate(objDiff, (DBObject)sysObj);
    }
}

