/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.SingleElementHandler;
import oracle.javatools.util.ModelUtil;

public class DBObjectXMLSupport {
    private final Map<String, DBObjectXMLHandler> m_handlers = new HashMap<String, DBObjectXMLHandler>();

    private DBObjectXMLSupport() {
    }

    public void registerHandler(DBObjectXMLHandler handler) {
        String namespace = handler.getNamespace();
        if (ModelUtil.hasLength((String)namespace)) {
            if (this.m_handlers.containsKey(namespace)) {
                throw new IllegalStateException("DBObjectXMLHandler for \"" + namespace + "\" already registered.");
            }
        } else {
            throw new IllegalArgumentException("DBObjectXMLHandler has no namespace defined");
        }
        this.m_handlers.put(namespace, handler);
    }

    public DBObjectXMLHandler getHandler(URL url) {
        return this.getHandler(DBObjectXMLSupport.getNamespace(url));
    }

    public DBObjectXMLHandler getHandler(String namespace) {
        DBObjectXMLHandler retval = null;
        if (ModelUtil.hasLength((String)namespace) && (retval = (DBObjectXMLHandler)((Object)DBCore.getInstance().getRegisteredFactory(DBObjectXMLHandler.class, namespace))) == null) {
            retval = this.m_handlers.get(namespace);
        }
        return retval;
    }

    public ClassLoader getClassLoader(String namespace) {
        DBObjectXMLHandler handler;
        ClassLoader clzLoader = null;
        if (ModelUtil.hasLength((String)namespace) && (handler = this.getHandler(namespace)) != null) {
            clzLoader = ((Object)((Object)handler)).getClass().getClassLoader();
        }
        if (clzLoader == null) {
            clzLoader = DBCore.getImplClassLoader();
        }
        return clzLoader;
    }

    public static DBObjectXMLSupport getInstance() {
        DBCore core = DBCore.getInstance();
        DBObjectXMLSupport retval = (DBObjectXMLSupport)core.get(DBObjectXMLSupport.class);
        if (retval == null) {
            retval = new DBObjectXMLSupport();
            core.put((Object)retval);
        }
        return retval;
    }

    public static String getNamespace(URL url) {
        try {
            InputStreamReader reader = new InputStreamReader(URLFileSystem.openInputStream((URL)url));
            return DBObjectXMLSupport.getNamespace(reader);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String getNamespace(Reader reader) {
        try {
            SingleElementHandler seh = new SingleElementHandler(null);
            DBObjectXMLHandler.read(reader, seh, true);
            return seh.getNamespace();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

