/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class JdbcTableBuilder<T extends Table>
extends JdbcRelationBuilder<T> {
    public JdbcTableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog, "TABLE");
    }

    public T createObject(String name, Schema schema, DBObjectID id) {
        Table table = (Table)super.createObject(name, schema, id);
        table.setProperty("TableType", (Object)Table.TableType.NORMAL);
        return (T)table;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes"}, depends={"constraints", "columns"})
    public final void fillInIndexes(T table) throws DBException {
        this.loadAndBuildIndexes(table);
    }

    protected void loadAndBuildIndexes(T table) throws DBException {
        String schemaName = this.isUseSchema() && table.getSchema() != null ? table.getSchema().getName() : null;
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            String tableName = this.getNameForDriver(table.getName());
            rs = dmd.getIndexInfo(null, this.getNameForDriver(schemaName), tableName, false, false);
            this.processIndexes(rs, table);
        }
        catch (SQLException ex) {
            this.checkUnsupportedOperation((DBObject)table, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIndexes(ResultSet rs, T table) throws DBException {
        TreeMap<String, Index> idxMap = new TreeMap<String, Index>();
        try {
            String tableName = this.getNameForDriver(table.getName());
            while (rs != null && rs.next()) {
                if (tableName == null && !rs.getString(3).equals(table.getName())) continue;
                boolean isUnique = !rs.getBoolean(4);
                String indexName = rs.getString(6);
                if (rs.getInt(7) == 0 || table.getConstraint(indexName) != null) continue;
                String colName = rs.getString(9);
                String ascDesc = rs.getString(10);
                Index index = (Index)idxMap.get(indexName);
                if (index == null) {
                    index = new Index(indexName, table);
                    index.setID((DBObjectID)new NameBasedID((DBObject)index, table.getID()));
                    idxMap.put(indexName, index);
                }
                index.setIndexType(isUnique ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
                Column col = table.getColumn(colName);
                if (col == null) continue;
                IndexObject.OrderType orderType = null;
                if (ascDesc != null) {
                    orderType = ascDesc.equals("A") ? IndexObject.OrderType.ASC : IndexObject.OrderType.DESC;
                }
                ColumnUsage colUsage = new ColumnUsage(col.getID());
                colUsage.setProvider((DBObjectProvider)this.getProvider());
                IndexObject io = new IndexObject((SQLFragment)colUsage, orderType);
                index.addColumnExpression(io);
            }
        }
        catch (SQLException ex) {
            this.checkUnsupportedOperation((DBObject)table, ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
                rs = null;
            }
        }
        Collection values = idxMap.values();
        Index[] indexes = values.toArray(new Index[values.size()]);
        table.setIndexes(indexes);
    }
}

