/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.db.informix.InformixTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;

public class InformixViewBuilder
extends JdbcViewBuilder {
    private static final String VIEW_TEXT_QUERY = " select v.viewtext  from sysviews v join systables t on ( t.tabid = v.tabid )  where t.tabname = ? and t.owner = ?  order by v.seqno ";

    public InformixViewBuilder(InformixDatabaseImpl db, String catalog) {
        super(db, catalog);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery"})
    public void buildQuery(final View view) throws DBException {
        final StringBuffer buffer = new StringBuffer();
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), VIEW_TEXT_QUERY, new Object[]{view, view.getSchema()});
        QueryWrapper.QueryRunnable run = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        buffer.append(rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)view, sqe);
                }
            }
        };
        wrap.executeQuery(run);
        String text = buffer.toString().trim();
        if (text.endsWith(";")) {
            text = text.substring(0, text.length() - 1);
        }
        this.decodeQueryString(text, view);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(View rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        Map<String, Object> retval = super.createDataTypeAttributes(rel, column, dataType, size, scale, jdbcTypeName);
        if (dataType != null) {
            String dataTypeName = dataType.getName();
            if ("VARCHAR".equals(dataTypeName) || "NVARCHAR".equals(dataTypeName)) {
                if (size != null) {
                    long length = size < 0L ? size + 65536L : size;
                    long reserve = length / 256L;
                    retval.put("size", length - reserve * 256L);
                    retval.put("reserve", reserve);
                }
            } else if ("INTERVAL".equals(dataTypeName) || "DATETIME".equals(dataTypeName)) {
                if (size != null) {
                    int precision = size.intValue() / 256;
                    int fromType = (size.intValue() - precision * 256) / 16;
                    int toType = size.intValue() - precision * 256 - fromType * 16;
                    retval.put("from", InformixTableBuilder.getTimeTypeName(fromType));
                    retval.put("to", InformixTableBuilder.getTimeTypeName(toType));
                    retval.put("precision", precision);
                    if (toType > 10) {
                        retval.put("scale", toType - 10);
                    } else {
                        retval.remove("scale");
                    }
                }
            } else if ("DECIMAL".equals(dataTypeName) && scale != null && scale.equals(255L)) {
                retval.remove("scale");
            }
        }
        return retval;
    }

    @Override
    protected String getQuerySearchString() {
        return "CREATE VIEW <name ?.> [(<cols {^)}...>)] AS <select {^{WITH CHECK OPTION|WITH READ ONLY}}...> <check [WITH CHECK OPTION]> <readOnly [WITH READ ONLY]>";
    }

    @Override
    public boolean canBuildEditableObject() {
        return true;
    }
}

