/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.informix.InformixConstraintValidator;
import oracle.javatools.db.informix.InformixDDLGenerator;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDynamicServer11;
import oracle.javatools.db.informix.InformixDynamicServerImpl;
import oracle.javatools.db.informix.InformixIndexValidator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class InformixDynamicServerDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACCESS", "ACCESS_METHOD", "ACTIVE", "ADD", "AFTER", "AGGREGATE", "ALIGNMENT", "ALL", "ALL_ROWS", "ALLOCATE", "ALTER", "AND", "ANSI", "ANY", "APPEND", "AS", "ASC", "AT", "ATTACH", "ATTACH", "AUDIT", "AUTHORIZATION", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BOOLEAN", "BOTH", "BUFFERED", "BUILTIN", "BY", "BYTE", "CACHE", "CALL", "CANNOTHASH", "CARDINALITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLASS", "CLIENT", "CLOSE", "CLUSTER", "CLUSTERSIZE", "COARSE", "COBOL", "CODESET", "COLLATION", "COLLECTION", "COLUMN", "COMMIT", "COMMITTED", "COMMUTATOR", "CONCURRENT", "CONNECT", "CONNECTION", "CONST", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "COPY", "COSTFUNC", "COUNT", "CRCOLS", "CREATE", "CROSS", "CURRENT", "CURSOR", "CYCLE", "DATABASE", "DATAFILES", "DATASKIP", "DATASOURCE", "DATE", "DATETIME", "DAY", "DBA", "DBDATE", "DBMONEY", "DBPASSWORD", "DEALLOCATE", "DEBUG", "DEC", "DEC_T", "DECIMAL", "DECLARE", "DECODE", "DEFAULT", "DEFERRED", "DEFERRED_PREPARE", "DEFINE", "DELAY", "DELETE", "DELIMITER", "DELUXE", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETACH", "DIAGNOSTICS", "DIRECTIVES", "DIRTY", "DISABLED", "DISCONNECT", "DISTINCT", "DISTRIBUTEBINARY", "DISTRIBUTESREFERENCES", "DISTRIBUTIONS", "DOCUMENT", "DOMAIN", "DONOTDISTRIBUTE", "DORMANT", "DOUBLE", "DROP", "DTIME_T", "EACH", "ELIF", "ELSE", "ENABLED", "ENCRYPTION", "END", "ENUM", "ENVIRONMENT", "ERROR", "ESCAPE", "EXCEPTION", "EXCLUSIVE", "EXEC", "EXECUTE", "EXECUTEANYWHERE", "EXISTS", "EXIT", "EXPLAIN", "EXPLICIT", "EXPRESS", "EXPRESSION", "EXTEND", "EXTENT", "EXTERNAL", "FALSE", "FAR", "FETCH", "FILE", "FILLFACTOR", "FILTERING", "FIRST", "FIRST_ROWS", "FIXCHAR", "FIXED", "FLOAT", "FLUSH", "FOR", "FOREACH", "FOREIGN", "FORMAT", "FORTRAN", "FOUND", "FRACTION", "FRAGMENT", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GK", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLESNULLS ", "HASH", "HAVING", "HIGH", "HINT", "HOLD", "HOUR", "HYBRID", "IF", "IFX_INT8_T", "IFX_LO_CREATE_SPEC_T", "IFX_LO_STAT_T", "IMMEDIATE", "IMPLICIT", "IN", "INACTIVE", "INCREMENT", "INDEX", "INDEXES", "INDICATOR", "INFORMIX", "INIT", "INLINE", "INNER", "INOUT", "INSERT", "INSTEAD", "INT", "INT8", "INTEG", "INTEGER", "INTERNAL", "INTERNALLENGTH", "INTERVAL", "INTO", "INTRVL_T", "IS", "ISCANONICAL", "ISOLATION", "ITEM", "ITERATOR", "JOIN", "KEEP", "KEY", "LABELEQ", "LABELGE", "LABELGLB", "LABELGT", "LABELLE", "LABELLT", "LABELLUB", "LABELTOSTRING", "LANGUAGE", "LAST", "LEADING", "LEFT", "LET", "LEVEL", "LIKE", "LIST", "LISTING", "LOAD", "LOC_T", "LOCAL", "LOCATOR", "LOCK", "LOCKS", "LOG", "LONG", "LOW", "LOWER", "LVARCHAR", "MATCHES", "MAX", "MAXERRORS", "MAXLEN", "MAXVALUE", "MDY", "MEDIAN", "MEDIUM", "MEMORY_RESIDENT", "MIDDLE", "MIN", "MINUTE", "MINVALUE", "MODE", "MODERATE", "MODIFY", "MODULE", "MONEY", "MONTH", "MOUNTING", "MULTISET", "NAME", "NCHAR", "NEGATOR", "NEW", "NEXT", "NO", "NOCACHE", "NOCYCLE", "NOMAXVALUE", "NOMIGRATE", "NOMINVALUE", "NON_RESIDENT", "NONE", "NOORDER", "NORMAL", "NOT", "NOTEMPLATEARG", "NULL", "NUMERIC", "NVARCHAR", "NVL", "OCTET_LENGTH", "OF", "OFF", "OLD", "ON", "ONLINE", "ONLY", "OPAQUE", "OPCLASS", "OPEN", "OPERATIONAL", "OPTCOMPIND", "OPTICAL", "OPTIMIZATION", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OUTER", "PAGE", "PARALLELIZABLE", "PARAMETER", "PARTITION", "PASCAL", "PASSEDBYVALUE", "PASSWORD", "PDQPRIORITY", "PERCALL_COST", "PLI", "PLOAD", "PRECISION", "PREPARE", "PREVIOUS", "PRIMARY", "PRIOR", "PRIVATE", "PRIVILEGES", "PROCEDURE", "PUBLIC", "PUT", "RAISE", "RANGE", "RAW", "READ", "REAL", "RECORDEND", "REF", "REFERENCES", "REFERENCING", "REGISTER", "REJECTFILE", "RELATIVE", "RELEASE", "REMAINDER", "RENAME", "REOPTIMIZATION", "REPEATABLE", "REPLICATION", "RESERVE", "RESOLUTION", "RESOURCE", "RESTART", "RESTRICT", "RESUME", "RETAIN", "RETURN", "RETURNING", "RETURNS", "REUSE", "REVOKE", "RIGHT", "ROBIN", "ROLE", "ROLLBACK", "ROLLFORWARD", "ROUND", "ROUTINE", "ROW", "ROWID", "ROWIDS", "ROWS", "SAMEAS", "SAMPLES", "SAVE", "SCHEDULE", "SCHEMA", "SCRATCH", "SCROLL", "SECOND", "SECONDARY", "SECTION", "SELCONST", "SELECT", "SELFUNC", "SEQUENCE", "SERIAL", "SERIAL8", "SERIALIZABLE", "SERVERUUID", "SESSION", "SET", "SHARE", "SHORT", "SIGNED", "SIZE", "SKALL", "SKINHIBIT", "SKSHOW", "SMALLFLOAT", "SMALLINT", "SOME", "SPECIFIC", "SQL", "SQLCODE", "SQLCONTEXT", "SQLERROR", "SQLSTATE", "SQLWARNING", "STABILITY", "STACK", "STANDARD", "START", "STATIC", "STATISTICS", "STDEV", "STEP", "STOP", "STORAGE", "STRATEGIES", "STRING", "STRINGTOLABEL", "STRUCT", "STYLE", "SUBSTR", "SUBSTRING", "SUM", "SUPPORT", "SYNC", "SYNONYM", "SYSTEM", "TABLE", "TEMP", "TEMPLATE", "TEST", "TEXT", "THEN", "TIME", "TIMEOUT", "TO", "TODAY", "TRACE", "TRAILING", "TRANSACTION", "TRIGGER", "TRIGGERS", "TRIM", "TRUE", "TRUNCATE", "TYPE", "TYPEDEF", "TYPEID", "TYPENAME", "TYPEOF", "UNCOMMITTED", "UNDER", "UNION", "UNIQUE", "UNITS", "UNKNOWN", "UNLOAD", "UNLOCK", "UNSIGNED", "UPDATE", "UPPER", "USAGE", "USE_SUBQF", "USER", "USING", "VALUE", "VALUES", "VAR", "VARCHAR", "VARIABLE", "VARIANCE", "VARIANT", "VARYING", "VIEW", "VIOLATIONS", "VOID", "VOLATILE", "WAIT", "WARNING", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "XADATASOURCE", "XID", "XLOAD", "XUNLOAD", "YEAR"));
    private static HashMap s_compatibleTypesMap;

    public InformixDynamicServerDescriptor(Class<? extends InformixDatabase> clz) {
        super(clz);
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new InformixDDLGenerator(this.getDatabaseClass(), pro);
    }

    @Override
    public int getCasePolicy() {
        return 1;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 128;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        this.checkInformixDatabaseIdentifier(name, "_$", RESERVED_WORDS);
    }

    protected void checkInformixDatabaseIdentifier(String name, String validChars, Set reservedWords) throws InvalidNameException {
        InformixDynamicServerDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)validChars, (boolean)false, (Set)reservedWords, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        char firstChar = name.charAt(0);
        if (firstChar != '\"' && !Character.isAlphabetic(name.codePointAt(0)) && firstChar != '_') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("INDEX", (DBObjectValidator)new InformixIndexValidator(pro));
        v.put("CONSTRAINT", new InformixConstraintValidator(pro));
        v.put("SYNONYM", (DBObjectValidator)new SynonymValidator(pro));
        return v;
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        boolean isValid = super.isValidFKDataTypeImpl(fktype, reftype);
        if (!isValid) {
            ArrayList compatibleRefTypes;
            if (s_compatibleTypesMap == null) {
                InformixDynamicServerDescriptor.initialiseCompatibleTypesMap();
            }
            if ((compatibleRefTypes = (ArrayList)s_compatibleTypesMap.get(fktype.getName())) != null && compatibleRefTypes.contains(reftype.getName())) {
                isValid = true;
            }
        }
        return isValid;
    }

    private static void initialiseCompatibleTypesMap() {
        s_compatibleTypesMap = new HashMap();
        String[] INT = new String[]{"INTEGER", "SERIAL"};
        String[] INTEGER = new String[]{"INT", "SERIAL"};
        String[] SERIAL = new String[]{"INT", "INTEGER"};
        String[] INT8 = new String[]{"SERIAL8"};
        String[] SERIAL8 = new String[]{"INT8"};
        s_compatibleTypesMap.put("INT", new ArrayList<String>(Arrays.asList(INT)));
        s_compatibleTypesMap.put("INTEGER", new ArrayList<String>(Arrays.asList(INTEGER)));
        s_compatibleTypesMap.put("SERIAL", new ArrayList<String>(Arrays.asList(SERIAL)));
        s_compatibleTypesMap.put("INT8", new ArrayList<String>(Arrays.asList(INT8)));
        s_compatibleTypesMap.put("SERIAL8", new ArrayList<String>(Arrays.asList(SERIAL8)));
    }

    @Override
    public String getDatabaseType() {
        return "Informix";
    }

    @Override
    public int getDatabaseVersion() {
        Class clz = this.getDatabaseClass();
        int retval = InformixDynamicServer11.class.isAssignableFrom(clz) ? 115 : (InformixDynamicServerImpl.class.isAssignableFrom(clz) ? 100 : 0);
        return retval;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        int version = this.getDatabaseVersion();
        if (version == 0) {
            cache.registerDataType("BYTE");
            cache.registerDataType("CHAR");
            cache.registerDataType("DATE");
            cache.registerDataType("DATETIME");
            cache.registerDataType("DECIMAL");
            cache.registerDataType("DOUBLE PRECISION");
            cache.registerDataType("FLOAT");
            cache.registerDataType("INT8");
            cache.registerDataType("INTEGER");
            cache.registerDataType("INTERVAL");
            cache.registerDataType("MONEY");
            cache.registerDataType("NCHAR");
            cache.registerDataType("NVARCHAR");
            cache.registerDataType("SERIAL");
            cache.registerDataType("SERIAL8");
            cache.registerDataType("SMALLFLOAT");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("TEXT");
            cache.registerDataType("VARCHAR");
            cache.registerDataTypeSynonym("CHARACTER", "CHAR");
            cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            cache.registerDataTypeSynonym("DEC", "DECIMAL");
            cache.registerDataTypeSynonym("INT", "INTEGER");
            cache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
            cache.registerDataTypeSynonym("REAL", "SMALLFLOAT");
        } else if (version == 100) {
            cache.registerDataType("BLOB");
            cache.registerDataType("BOOLEAN");
            cache.registerDataType("CLOB");
            cache.registerDataType("LVARCHAR");
            cache.registerDataType("NVARCHAR");
            cache.registerDataType("VARCHAR");
        }
    }
}

