/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.Collection;
import java.util.regex.Pattern;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class HiveStoragePropertiesValidator
extends AbstractChildDBObjectValidator<HiveStorageProperties> {
    private Pattern m_javaPattern;

    public HiveStoragePropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("hdfsLocation");
        retval.add("predefinedFileFormat");
        for (String prop : HivePropertyMetadata.getDelimitedProperties()) {
            retval.add(prop);
        }
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"inputFormatClass"}, level=ValidationLevel.FULL)
    public void validateInputFormat(HiveStorageProperties orig, HiveStorageProperties props) throws ValidationException {
        this.validateClassName(props, props.getInputFormatClass());
    }

    @DBObjectValidator.PropertyValidator(value={"outputFormatClass"}, level=ValidationLevel.FULL)
    public void validateOutputtFormat(HiveStorageProperties orig, HiveStorageProperties props) throws ValidationException {
        this.validateClassName(props, props.getOutputFormatClass());
    }

    @DBObjectValidator.PropertyValidator(value={"serDeClass"}, level=ValidationLevel.FULL)
    public void validateSerDe(HiveStorageProperties orig, HiveStorageProperties props) throws ValidationException {
        this.validateClassName(props, props.getSerDeClass());
    }

    @DBObjectValidator.PropertyValidator(value={"storageHandlerClass"}, level=ValidationLevel.FULL)
    public void validateStorageHandler(HiveStorageProperties orig, HiveStorageProperties props) throws ValidationException {
        this.validateClassName(props, props.getStorageHandlerClass());
    }

    private void validateClassName(HiveStorageProperties props, String clz) throws ValidationException {
        if (ModelUtil.hasLength((String)clz)) {
            Pattern p = this.m_javaPattern;
            if (p == null) {
                this.m_javaPattern = p = Pattern.compile("([\\p{L}_\\p{Sc}][\\p{L}\\p{N}_\\p{Sc}]*\\.)*[\\p{L}_\\p{Sc}][\\p{L}\\p{N}_\\p{Sc}]*");
            }
            if (!p.matcher(clz).matches()) {
                throw new ValidationException((DBObject)props, HiveBundle.format("INVALID_CLASS_NAME", clz));
            }
        }
    }
}

