/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.hive.HiveDDLType;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.property.Property;

public class HiveDDLGenerator
extends BundleDDLGenerator<HiveDDLType> {
    private static final String BUNDLE_NAME = "HiveDDL.properties";

    public HiveDDLGenerator(DBObjectProvider pro) {
        super(HiveDatabaseImpl.class, pro, new String[]{BUNDLE_NAME});
        this.registerTokenGenerator("nonPartitionColumns", new ColumnsGen());
    }

    private int getDatabaseVersion() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? 14 : pro.getDescriptor().getDatabaseVersion();
    }

    protected boolean canChangeWithAlter(SystemObject orig, SystemObject update, String prop) {
        boolean retval;
        HiveStorageProperties origHTP;
        HiveStorageProperties hiveStorageProperties = origHTP = orig instanceof Table ? (HiveStorageProperties)orig.getProperty("HiveStorageProperties") : null;
        if (origHTP != null && origHTP.getStorageHandlerClass() != null) {
            retval = false;
        } else {
            retval = super.canChangeWithAlter(orig, update, prop);
            if (!retval) {
                String last = Property.getLastProperty((String)prop);
                retval = HivePropertyMetadata.getDelimitedProperties().contains(last);
            }
        }
        return retval;
    }

    protected HiveDDLType getDDLType(String type) {
        return new HiveDDLType(HiveDDLType.StatementType.valueOf(type));
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        List<Table.TableType> retval = "TableType".equals(property) ? Arrays.asList(Table.TableType.NORMAL, Table.TableType.EXTERNAL) : super.getAllowedPropertyValues(originalObject, updatedObject, property);
        if ("predefinedFileFormat".equals(property) && this.getDatabaseVersion() < 14) {
            retval.remove(HiveStorageProperties.PredefinedFileFormat.AVRO);
        }
        return retval;
    }

    public boolean supportsProperty(Class<? extends DBObject> objClz, String prop) {
        boolean retval = super.supportsProperty(objClz, prop);
        if (retval && HiveStorageProperties.class.equals(objClz) && "nullFormat".equals(prop)) {
            int ver = this.getDatabaseVersion();
            retval = ver >= 13;
        }
        return retval;
    }

    private static class ColumnsGen
    extends TokenGenerator {
        static final String TOKEN = "nonPartitionColumns";

        private ColumnsGen() {
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("columns");
        }

        public Object evaluateToken(TokenContext context) {
            Object retval = null;
            Object obj = context.getObject();
            if (obj instanceof Relation) {
                DBObjectID[] partColIDs;
                Column[] cols;
                Relation r = (Relation)obj;
                retval = cols = r.getColumns();
                HivePartitionProperties parts = (HivePartitionProperties)r.getProperty("HivePartitionProperties");
                if (parts != null && (partColIDs = parts.getPartitionColumns()) != null && partColIDs.length > 0) {
                    ArrayList<Column> list = new ArrayList<Column>();
                    for (Column c : cols) {
                        if (this.contains(c.getID(), partColIDs)) continue;
                        list.add(c);
                    }
                    retval = list;
                }
            }
            return retval;
        }

        private boolean contains(DBObjectID id, DBObjectID[] ids) {
            boolean retval = false;
            if (id != null) {
                for (DBObjectID other : ids) {
                    if (!id.equals(other, true)) continue;
                    retval = true;
                    break;
                }
            }
            return retval;
        }

        public void generateToken(TokenContext context) {
            throw new UnsupportedOperationException("generate not supported for nonPartitionColumns");
        }
    }
}

