/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Database;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerSynonymBuilder;
import oracle.javatools.db.SQLServer.SQLServerTableBuilder;
import oracle.javatools.db.SQLServer.SQLServerViewBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public class SQLServerDatabaseImpl
extends JdbcDDLDatabase
implements SQLServerDatabase {
    public SQLServerDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected void registerBuilders() {
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new SQLServerSynonymBuilder(this));
        this.registerBuilder("TABLE", (DBObjectBuilder)new SQLServerTableBuilder(this));
        this.registerBuilder("VIEW", (DBObjectBuilder)new SQLServerViewBuilder(this));
    }

    @Override
    public String normaliseDataTypeName(String dmdDataTypeName) {
        return dmdDataTypeName.trim().toUpperCase().replaceAll(" IDENTITY", "").replaceAll("\\(\\)", "");
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        defaultValue = defaultValue.replaceAll("\\(", "");
        defaultValue = defaultValue.replaceAll("\\)", "");
        return defaultValue;
    }

    protected void processDeleteException(DBException dbe, SystemObject obj) throws DBException {
        int code;
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException && (code = ((SQLException)cause).getErrorCode()) == 3726) {
            throw new CascadeRequiredException((DBObject)obj, ((SQLException)cause).getMessage());
        }
        throw dbe;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        final Collection<T> retval = super.listObjectsImpl(criteria);
        if (criteria.isAllowedType("SYNONYM")) {
            DBObjectBuilder builder = this.getBuilderForType("SYNONYM");
            final Schema schema = this.findSchema(criteria.getSchemaName());
            if (builder != null) {
                final QueryWrapper wrap = new QueryWrapper((Database)this, " SELECT sy.name  FROM sys.synonyms sy, sys.schemas sc  WHERE sy.schema_id = sc.schema_id AND sc.name = ? AND sy.name LIKE( ? ) ", new Object[]{schema, criteria.getNameLike()});
                wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                String name = rs.getString(1);
                                SystemObject object = SQLServerDatabaseImpl.this.findOrCreateObject("SYNONYM", null, schema, name, null);
                                retval.add(object);
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(sqe);
                        }
                    }
                });
            }
        }
        return retval;
    }
}

