/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServer2005;
import oracle.javatools.db.SQLServer.SQLServer2008;
import oracle.javatools.db.SQLServer.SQLServer2012;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.util.Holder;
import oracle.javatools.util.Version;

public class SQLServerDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        SQLServerDatabaseImpl ret = null;
        int t = this.getSQLServerConnectionVersion(connName, conn);
        if (t == 110) {
            ret = new SQLServer2012(connStore, connName, conn);
        } else if (t == 100) {
            ret = new SQLServer2008(connStore, connName, conn);
        } else if (t == 90) {
            ret = new SQLServer2005(connStore, connName, conn);
        } else if (t == 80) {
            ret = new SQLServerDatabaseImpl(connStore, connName, conn);
        }
        return ret;
    }

    private int getSQLServerConnectionVersion(String connName, Connection conn) {
        int majorVer;
        block15: {
            majorVer = -1;
            if (conn != null) {
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String databaseName = dmd.getDatabaseProductName();
                    if (databaseName.indexOf("Microsoft SQL Server") <= -1) break block15;
                    try {
                        majorVer = dmd.getDatabaseMajorVersion();
                    }
                    catch (Throwable t) {
                        final Holder h = new Holder();
                        final QueryWrapper wrap = new QueryWrapper(connName, conn, "select SERVERPROPERTY('ProductVersion')", new Object[0]);
                        QueryWrapper.QueryRunnable run = new QueryWrapper.QueryRunnable(){

                            public void processResultSet(ResultSet rs) throws DBException {
                                block5: {
                                    try {
                                        if (!rs.next()) break block5;
                                        try {
                                            Version productVer = new Version(rs.getString(1));
                                            int[] versionParts = productVer.toIntArray();
                                            if (versionParts != null) {
                                                h.set((Object)versionParts[0]);
                                            }
                                        }
                                        catch (NumberFormatException nfe) {
                                            DBLog.getLogger((Object)this).fine(nfe.getMessage());
                                        }
                                    }
                                    catch (SQLException sqe) {
                                        wrap.throwDBException(sqe);
                                    }
                                }
                            }
                        };
                        try {
                            wrap.executeQuery(run);
                            Integer mv = (Integer)h.get();
                            if (mv != null) {
                                majorVer = mv;
                            }
                        }
                        catch (DBException dBException) {}
                    }
                }
                catch (SQLException dmd) {
                    // empty catch block
                }
            }
        }
        int retval = -1;
        if (majorVer >= 11) {
            retval = 110;
        } else if (majorVer == 10) {
            retval = 100;
        } else if (majorVer == 9) {
            retval = 90;
        } else if (majorVer >= 0) {
            retval = 80;
        }
        return retval;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        SQLServerDatabaseDescriptor retval = null;
        if (SQLServerDatabase.class.isAssignableFrom(providerClass)) {
            retval = new SQLServerDatabaseDescriptor(providerClass);
        }
        return retval;
    }
}

