/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.plsql.Function;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.FunctionBuilder;
import oracle.javatools.db.plsql.parser.PlSqlFragmentBuilder;
import oracle.javatools.db.plsql.parser.PlSqlReferenceBuilder;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.db.plsql.parser.PlSqlSpecAndBodyBuilder;
import oracle.javatools.db.plsql.parser.TriggerBuilder;
import oracle.javatools.db.plsql.parser.TypeBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.sql.BaseSqlAliasExpander;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLDerivedPropertySupport;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.SchemaValidator;
import oracle.javatools.db.validators.TableValidator;

public abstract class BaseDatabaseDescriptor
extends DatabaseDescriptor {
    protected BaseDatabaseDescriptor(Class<? extends Database> clz) {
        super(clz);
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)((Object)this));
    }

    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, SchemaValidator> v = DBObjectRegistry.isActive() ? DBObjectRegistry.getInstance().getValidators(this.getDatabaseType(), this.getDatabaseVersion(), pro) : new HashMap<String, SchemaValidator>();
        v.put("SCHEMA", new SchemaValidator(pro));
        v.put("INDEX", (SchemaValidator)((Object)new IndexValidator(pro)));
        v.put("CONSTRAINT", (SchemaValidator)((Object)new ConstraintValidator(pro)));
        v.put("COLUMN", (SchemaValidator)((Object)new ColumnValidator(pro)));
        v.put("DataTypeUsage", (SchemaValidator)((Object)new DataTypeUsageValidator(pro)));
        v.put("TABLE", (SchemaValidator)((Object)new TableValidator(pro)));
        return v;
    }

    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider pro) {
        ArrayList<PropertyInitializer> pdpList = new ArrayList<PropertyInitializer>();
        pdpList.add(new BasePropertyInitializer(pro));
        return pdpList;
    }

    public List<UpdateProcessor> getUpdateProcessors() {
        ArrayList<UpdateProcessor> retval = new ArrayList<UpdateProcessor>();
        retval.add((UpdateProcessor)new TemplateExpander());
        return retval;
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider pro, Schema defaultSchema) {
        return new BaseSqlAliasExpander(pro, defaultSchema);
    }

    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> objClz, DBObjectProvider pro) {
        AbstractPlSqlBuilder retval = super.getDerivedPropertyBuilder(objClz, pro);
        if (retval == null) {
            if (CheckConstraint.class.isAssignableFrom(objClz)) {
                retval = SQLDerivedPropertySupport.createCheckConstraintBuilder(pro);
            } else if (Column.class.isAssignableFrom(objClz)) {
                if (pro.getPropertyManager().findPropertyInfo(objClz, "virtualExpressionSource") != null) {
                    retval = SQLDerivedPropertySupport.createVirtualExpressionBuilder(pro);
                }
            } else if (IndexObject.class.isAssignableFrom(objClz)) {
                retval = SQLDerivedPropertySupport.createIndexExpressionBuilder(pro);
            } else if (SQLQuery.class.isAssignableFrom(objClz)) {
                SQLQueryBuilder builder = this.getSQLQueryBuilderFactory().createSQLQueryBuilder(pro);
                if (builder instanceof DerivedPropertyBuilder) {
                    retval = (DerivedPropertyBuilder)builder;
                }
            } else if (SynonymUsage.class.isAssignableFrom(objClz)) {
                retval = new SQLDerivedPropertySupport.SynonymUsageBuilder((AbstractDBObjectProvider)pro);
            } else if (Relation.class.isAssignableFrom(objClz) && SQLQueryOwner.class.isAssignableFrom(objClz)) {
                retval = new SQLDerivedPropertySupport.SQLQueryColumnsBuilder((AbstractDBObjectProvider)pro, Metadata.getType(objClz));
            } else if (Function.class.isAssignableFrom(objClz)) {
                retval = new FunctionBuilder((AbstractDBObjectProvider)pro);
            } else if (Procedure.class.isAssignableFrom(objClz)) {
                retval = new PlSqlSourceObjectBuilder((AbstractDBObjectProvider)pro, "PROCEDURE");
            } else if (Trigger.class.isAssignableFrom(objClz)) {
                retval = new TriggerBuilder((AbstractDBObjectProvider)pro);
            } else if (Package.class.isAssignableFrom(objClz)) {
                retval = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)pro, "PACKAGE");
            } else if (PackageBody.class.isAssignableFrom(objClz)) {
                retval = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)pro, "PACKAGE BODY");
            } else if (Type.class.isAssignableFrom(objClz)) {
                retval = new TypeBuilder((AbstractDBObjectProvider)pro);
            } else if (TypeBody.class.isAssignableFrom(objClz)) {
                retval = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)pro, "TYPE BODY");
            } else if (PlSqlReference.class.isAssignableFrom(objClz)) {
                retval = new PlSqlReferenceBuilder((AbstractDBObjectProvider)pro);
            } else if (PlSqlCodeFragment.class.isAssignableFrom(objClz)) {
                retval = new PlSqlFragmentBuilder((AbstractDBObjectProvider)pro, Metadata.getType(objClz));
            }
        }
        return retval;
    }

    private static class BasePropertyInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"name"};
        private final boolean m_lower = this.getProvider().getDescriptor().getCasePolicy() == 1;

        BasePropertyInitializer(DBObjectProvider pro) {
            super(pro);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clz) {
            return s_names;
        }

        public Object getPropertyInitialValue(DBObject obj, String propertyName) throws PropertyInitializer.InitializationVeto {
            String retval = null;
            if ("name".equals(propertyName)) {
                boolean checkUniqueName;
                DBObject uniqueNameContext;
                boolean createName;
                String type;
                if (obj.getName() != null) {
                    throw new PropertyInitializer.InitializationVeto();
                }
                DBObjectProvider pro = this.getProvider();
                if (pro.supportsObjectType(type = obj.getType())) {
                    createName = true;
                    uniqueNameContext = DBUtil.getSchema((DBObject)obj);
                    checkUniqueName = !(obj instanceof SchemaObject) || uniqueNameContext != null;
                } else {
                    uniqueNameContext = obj.getParent();
                    DBObjectValidator validator = ((AbstractDBObjectProvider)pro).getValidatorForType(type);
                    checkUniqueName = validator != null && validator.getNamespaceType() != DBObjectValidator.NamespaceType.NONE;
                    boolean bl = createName = validator != null && validator.initializeWithDefaultName();
                }
                if (createName) {
                    String typeName = obj instanceof MaterializedView ? "MVIEW" : type.replaceAll(" ", "_");
                    retval = obj instanceof Index && obj.getParent() instanceof Table ? obj.getParent().getName() + "_" + typeName + "1" : typeName + "1";
                    if (this.m_lower) {
                        retval = retval.toLowerCase();
                    }
                    if (checkUniqueName) {
                        retval = pro.getUniqueName(obj.getType(), uniqueNameContext, retval);
                    }
                } else {
                    throw new PropertyInitializer.InitializationVeto();
                }
            }
            return retval;
        }
    }
}

