/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.icons;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public final class IconScaler {
    private static final Map<Icon, Map<Integer, SoftReference<Icon>>> cache = new ConcurrentHashMap<Icon, Map<Integer, SoftReference<Icon>>>();

    public static Icon scaleIcon(Icon originalIcon, int maxHeight) {
        if (originalIcon.getIconHeight() <= maxHeight) {
            return originalIcon;
        }
        Map<Integer, SoftReference<Icon>> sizeMap = cache.get(originalIcon);
        if (sizeMap == null) {
            sizeMap = new ConcurrentHashMap<Integer, SoftReference<Icon>>();
            cache.put(originalIcon, sizeMap);
        }
        SoftReference<Icon> iconRef = sizeMap.get(maxHeight);
        Icon scaledIcon = null;
        if (iconRef != null) {
            scaledIcon = iconRef.get();
        }
        if (scaledIcon == null) {
            scaledIcon = IconScaler.createScaledIcon(originalIcon, maxHeight);
            iconRef = new SoftReference<Icon>(scaledIcon);
            sizeMap.put(maxHeight, iconRef);
        }
        return scaledIcon;
    }

    private static Icon createScaledIcon(Icon originalIcon, int height) {
        BufferedImage originalImage = new BufferedImage(originalIcon.getIconWidth(), originalIcon.getIconHeight(), 2);
        Graphics2D g = originalImage.createGraphics();
        JPanel dummyComponent = new JPanel();
        originalIcon.paintIcon(dummyComponent, g, 0, 0);
        g.dispose();
        float scale = (float)height / (float)originalIcon.getIconHeight();
        int width = (int)((float)originalIcon.getIconWidth() * scale);
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = scaledImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(originalImage, 0, 0, width, height, null);
        g2.dispose();
        ImageIcon scaledIcon = new ImageIcon(scaledImage);
        return scaledIcon;
    }
}

