/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class SQLStatement {
    protected AST m_tree;
    protected Block m_block;
    protected HashMap<String, String> m_tableRefMap;
    protected ArrayList<SQLStatement> m_nestedStmts;
    protected LinkedHashMap<TranslationDBObjectReference, String> m_columns;
    protected String m_dmlTargetName;
    protected int m_identityColumnIndex = -20;
    public static final int IDENTITYNOTCHECKED = -20;
    public static final int IDENTITYNOTPRESENT = -1;

    public SQLStatement(AST aST) {
        this.m_tree = aST;
        this.m_tableRefMap = new HashMap();
        this.m_nestedStmts = new ArrayList();
        this.m_columns = new LinkedHashMap();
    }

    public SQLStatement(AST aST, Block block) {
        this(aST);
        this.m_block = block;
    }

    public AST getTree() {
        return this.m_tree;
    }

    public Block getBlock() {
        return this.m_block;
    }

    public void setDMLTarget(String string) {
        this.m_dmlTargetName = string;
    }

    public String getDMLTarget() {
        return this.m_dmlTargetName == null ? "" : this.m_dmlTargetName;
    }

    public void addTableReference(String string, String string2) {
        String string3 = this.getUniqueTableKey(string, string2);
        if (this.m_tableRefMap.containsKey(string3)) {
            return;
        }
        this.m_tableRefMap.put(string3, string2);
    }

    private String getUniqueTableKey(String string, String string2) {
        return string.toUpperCase() + (string2 != null ? ":" + string2.toUpperCase() : "");
    }

    public String[] getTableReferenceAlias(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.m_tableRefMap.keySet()) {
            if (string2.toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
            arrayList.add(this.m_tableRefMap.get(string2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getTableNameFromKey(String string) {
        if (string.indexOf(":") == -1) {
            return string;
        }
        return string.substring(0, string.indexOf(":"));
    }

    public String getTableNameForAlias(String string) {
        if (string == null) {
            return null;
        }
        for (String string2 : this.m_tableRefMap.keySet()) {
            if (!string.equalsIgnoreCase(this.m_tableRefMap.get(string2))) continue;
            return this.getTableNameFromKey(string2);
        }
        return null;
    }

    public String[] getTableNames() {
        int n = 0;
        String[] stringArray = new String[this.m_tableRefMap.size()];
        for (String string : this.m_tableRefMap.keySet()) {
            stringArray[n++] = this.getTableNameFromKey(string);
        }
        return stringArray;
    }

    public String getTableNameWithoutAlias() {
        String string = null;
        for (String string2 : this.m_tableRefMap.keySet()) {
            if (this.m_tableRefMap.get(string2) != null) continue;
            string = string2;
        }
        return string;
    }

    public boolean hasTableName(String string) {
        return this.hasTableName(string, false);
    }

    public boolean hasTableName(String string, boolean bl) {
        for (String string2 : this.m_tableRefMap.keySet()) {
            if (!this.getTableNameFromKey(string2).equalsIgnoreCase(string)) continue;
            return true;
        }
        if (bl) {
            for (String string2 : this.m_tableRefMap.values()) {
                if (string2 == null || !this.getTableNameFromKey(string2).equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addNestedSQLStatement(SQLStatement sQLStatement) {
        this.m_nestedStmts.add(sQLStatement);
    }

    public void addColumn(String string, String string2) {
        this.m_columns.put(new TranslationDBObjectReference(null, null, null, string, null, TranslationObjectType.COLUMN_TYPE, null), string2);
    }

    public TranslationDBObjectReference getColumn(int n) {
        TranslationDBObjectReference translationDBObjectReference = null;
        if (n < this.m_columns.size()) {
            int n2 = 0;
            for (TranslationDBObjectReference translationDBObjectReference2 : this.m_columns.keySet()) {
                if (n2 == n) {
                    translationDBObjectReference = translationDBObjectReference2;
                    break;
                }
                ++n2;
            }
        }
        return translationDBObjectReference;
    }

    public TranslationDBObjectReference[] getColumns() {
        return this.m_columns.keySet().toArray(new TranslationDBObjectReference[this.m_columns.size()]);
    }

    public String getAliasForColumn(TranslationDBObjectReference translationDBObjectReference) {
        return this.m_columns.get(translationDBObjectReference);
    }

    public boolean hasIdentityColumn(TranslationHelper translationHelper) {
        if (this.m_identityColumnIndex == -20) {
            this.initIdentity(translationHelper);
        }
        return this.m_identityColumnIndex != -20 && this.m_identityColumnIndex != -1;
    }

    private void initIdentity(TranslationHelper translationHelper) {
        this.m_identityColumnIndex = -1;
        List<TranslationColumn> list = translationHelper.getTableHelper().getColumnsFromContext(this.getTableNames()[0]);
        if (list != null) {
            for (TranslationColumn translationColumn : list) {
                if (translationColumn.getDefaultValue() == null || translationColumn.getDefaultValue().toUpperCase().indexOf("IDENTITY") == -1) continue;
                this.m_identityColumnIndex = translationColumn.getColumnIndex();
                break;
            }
        }
    }

    public int getIdentityColumnIndex() {
        return this.m_identityColumnIndex;
    }
}

