/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.QueryCursorHelper;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Cursor;
import oracle.dbtools.migration.translation.api.components.CursorScope;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;

public class CursorHelper {
    private CodeBlockManager m_codeBlockMgr;
    private TranslationMetaData m_translationMetaData;
    private QueryCursorHelper m_cursorVarMgr;
    private HashMap<String, Cursor> m_cursorMap;

    public CursorHelper(CodeBlockManager codeBlockManager, TranslationMetaData translationMetaData) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_translationMetaData = translationMetaData;
        this.m_cursorMap = new HashMap();
        this.m_cursorVarMgr = new QueryCursorHelper(translationMetaData);
    }

    public void addCursor(AST aST, Block block, String string, boolean bl) {
        Cursor cursor = new Cursor(aST, block, string, bl);
        this.m_cursorMap.put(this.getKey(this.getProgramBlock(aST), string), cursor);
    }

    public void addCursor(AST aST, String string) {
        Block block = this.getProgramBlock(aST);
        if (block == null) {
            return;
        }
        String string2 = this.getKey(block, string);
        Cursor cursor = this.m_cursorMap.get(string2);
        if (cursor != null) {
            if (cursor.isDynamic()) {
                cursor.addCursorDeclaration(aST);
            } else {
                cursor.addCursorDeclaration(aST);
            }
        } else {
            this.m_cursorMap.put(string2, new Cursor(aST, block, string));
        }
    }

    private boolean isEnclosedByIfElseBlock(Block block) {
        boolean bl = false;
        Block block2 = block.getParent();
        if (block2 != null) {
            boolean bl2;
            boolean bl3 = bl2 = block2.hasAltBlock() || "IF".equalsIgnoreCase(block2.getBlockName());
            if ("CONTROLBLOCK".equalsIgnoreCase(block2.getBlockType()) && bl2) {
                bl = true;
            }
        }
        return bl;
    }

    public TranslationParameter addCursorVariable(AST aST) {
        TranslationParameter translationParameter = null;
        if (this.m_cursorVarMgr.isRefCursorRequired(aST)) {
            Block block = ((ExtAST)aST).getBlock();
            if (block == null) {
                this.m_codeBlockMgr.findEnclosingBlock(aST, "STMTBLOCK");
            }
            translationParameter = this.m_cursorVarMgr.addCursorVariable(aST, block);
        }
        return translationParameter;
    }

    public void addCursorVariable(AST aST, String string) {
        this.addCursorVariable(aST, string, false, false);
    }

    public void addCursorVariable(AST aST, String string, boolean bl) {
        this.addCursorVariable(aST, string, bl, false);
    }

    public void addCursorVariable(AST aST, String string, boolean bl, boolean bl2) {
        Block block = bl2 ? this.getParameterBlock(aST) : this.getProgramBlock(aST);
        String string2 = this.getKey(block, string);
        Cursor cursor = this.m_cursorMap.get(string2);
        if (cursor == null) {
            cursor = new Cursor(aST, block, string, true);
            this.m_cursorMap.put(string2, cursor);
        }
        cursor.setParameter(bl2);
        if (bl) {
            this.setCursorScopeBegin(aST, string);
        }
    }

    public String getCursorVariableName(AST aST) {
        return this.m_cursorVarMgr.getCursorName(aST);
    }

    public String getTargetCursorName(AST aST, String string) {
        Cursor cursor = this.getCursor(aST, string);
        return cursor != null ? cursor.getTargetName() : string;
    }

    public Cursor[] getCursors() {
        return this.m_cursorMap.values().toArray(new Cursor[this.m_cursorMap.size()]);
    }

    public void addUpdateColumn(AST aST, String string, String string2) {
        Cursor cursor = this.getCursor(aST, string);
        if (cursor != null) {
            cursor.addUpdateColumn(string2);
        }
    }

    public void setSelectStatement(AST aST, String string, String string2) {
        Cursor cursor = this.getCursor(aST, string);
        if (cursor != null) {
            cursor.setSelectStatement(string2);
        }
    }

    public String getSelectStatement(AST aST, String string) {
        Cursor cursor = this.getCursor(aST, string);
        return cursor != null ? cursor.getSelectStatement() : null;
    }

    public boolean hasMultipleDeclarations(AST aST, String string) {
        Cursor cursor = this.getCursor(aST, string);
        return cursor != null ? cursor.hasMultipleDeclarations() : false;
    }

    public String getCursorNameInScope(AST aST) {
        CursorScope cursorScope = null;
        String string = null;
        for (Cursor cursor : this.m_cursorMap.values()) {
            CursorScope cursorScope2;
            if (!cursor.hasUsageValidScope() || (cursorScope2 = cursor.findCursorScope(aST)) == null || cursorScope != null && (cursorScope == null || cursorScope2.compareScope(cursorScope) >= 0)) continue;
            cursorScope = cursorScope2;
            string = cursor.getName();
        }
        return string;
    }

    public void setCursorScopeBegin(AST aST, String string) {
        Iterator<Cursor> iterator = this.m_cursorMap.values().iterator();
        while (iterator.hasNext()) {
            Cursor cursor;
            Block block = (cursor = iterator.next()).isParameter() ? this.getParameterBlock(aST) : this.getProgramBlock(aST);
            if (!cursor.equals(block, string)) continue;
            cursor.setUsageValidScopeStart(aST);
            break;
        }
    }

    public void setCursorScopeEnd(AST aST, String string) {
        for (Cursor cursor : this.m_cursorMap.values()) {
            Block block;
            if (!cursor.hasUsageValidScope() || !cursor.equals(block = cursor.isParameter() ? this.getParameterBlock(aST) : this.getProgramBlock(aST), string)) continue;
            cursor.setUsageValidScopeEnd(aST);
            break;
        }
    }

    private Block getProgramBlock(AST aST) {
        Block block = ((ExtAST)aST).getBlock();
        if (block == null) {
            block = this.m_codeBlockMgr.findEnclosingBlock(aST, "STMTBLOCK");
        }
        if (block != null && this.isEnclosedByIfElseBlock(block = block.getEnclosingProgramBlock())) {
            block = block.getParent().getEnclosingProgramBlock();
        }
        return block;
    }

    private Block getParameterBlock(AST aST) {
        return this.m_codeBlockMgr.findEnclosingBlock(aST, "CREATEOBJBLOCK");
    }

    public Cursor getCursor(AST aST, String string) {
        Block block = this.getProgramBlock(aST);
        if (block == null) {
            block = this.getParameterBlock(aST);
        }
        if (block == null) {
            return null;
        }
        Cursor cursor = null;
        String string2 = this.getKey(block, string);
        cursor = this.m_cursorMap.get(string2);
        return cursor;
    }

    private String getKey(Block block, String string) {
        return block.getSourceStartLine() + ":" + block.getSourceEndLine() + ":" + string;
    }
}

