/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;

public class StatusEditorController
implements Controller,
ContextMenuListener,
DynamicMenuListener,
PropertyChangeListener {
    private static StatusEditorController instance;
    private AuditPreferences preferences;
    private IdeAction codeAssistAction;
    private static final Log LOG;
    private static final String KEY;
    private JComponent[] dynamicActions;
    private JComponent[] noActions = new JComponent[0];

    public static synchronized StatusEditorController getController() {
        if (instance == null) {
            instance = new StatusEditorController();
        }
        return instance;
    }

    private StatusEditorController() {
        this.preferences = AuditManager.getAuditManager().getPreferences();
        int cid = Ide.findOrCreateCmdID((String)"oracle.ide.status.editor.CodeAssistCommand");
        this.codeAssistAction = IdeAction.get((int)cid);
        this.codeAssistAction.addController((Controller)this);
        LOG.trace("creating status editor controller {0}", (Object)this);
        this.preferences.addPropertyChangeListener("auditWhileEditing", (PropertyChangeListener)this);
        if (this.preferences.isAuditWhileEditing()) {
            this.start();
        }
    }

    AuditPreferences getPreferences() {
        return this.preferences;
    }

    private void start() {
        LOG.trace("starting background audit");
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        StatusEditorPlugin.getStatusContextMenu().addContextMenuListener((ContextMenuListener)this);
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
    }

    private void stop() {
        LOG.trace("stopping background audit");
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().removeContextMenuListener((ContextMenuListener)this);
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object value = event.getNewValue();
        LOG.trace("property {0} changed to {1}", (Object)name, value);
        if (name.equals("auditWhileEditing")) {
            if (Boolean.TRUE.equals(value)) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    public boolean update(IdeAction action, Context context) {
        StatusEditorPlugin plugin;
        if (action != this.codeAssistAction) {
            return false;
        }
        View view = context.getView();
        Object editor = view instanceof CodeEditor ? ((CodeEditor)view).getFocusedEditorPane() : (view instanceof CodeEditorGutterView ? ((CodeEditor)view.owner()).getFocusedEditorPane() : null);
        if (editor != null && (plugin = (StatusEditorPlugin)editor.getProperty(KEY)) != null) {
            this.codeAssistAction.setEnabled(plugin.isCodeAssistPopupEnabled());
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            if (action == this.codeAssistAction) {
                BasicEditorPane editor = ((CodeEditor)view).getFocusedEditorPane();
                StatusEditorPlugin plugin = null;
                if (editor != null) {
                    plugin = (StatusEditorPlugin)editor.getProperty(KEY);
                }
                if (plugin != null && plugin.isCodeAssistPopupEnabled()) {
                    plugin.showCodeAssistPopup(context);
                } else {
                    editor.getToolkit().beep();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu menu) {
        if (Product.isRaptor()) {
            return;
        }
        Context context = menu.getContext();
        EventObject event = context.getEvent();
        if (!(event instanceof MouseEvent)) {
            return;
        }
        View view = context.getView();
        if (view instanceof CodeEditor) {
            BasicEditorPane editor = ((CodeEditor)view).getFocusedEditorPane();
            StatusEditorPlugin plugin = (StatusEditorPlugin)editor.getProperty(KEY);
            if (plugin == null) {
                return;
            }
            JMenuItem menuItem = menu.createMenuItem((ToggleAction)this.codeAssistAction, 135.0f);
            menuItem.setEnabled(plugin.isCodeAssistPopupEnabled());
            menu.add((Component)menuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        } else if (view instanceof CodeEditorGutterView) {
            GutterMark mark;
            String columnName;
            BasicEditorPane editor = ((CodeEditor)view.owner()).getFocusedEditorPane();
            StatusEditorPlugin plugin = (StatusEditorPlugin)editor.getProperty(KEY);
            if (plugin == null) {
                return;
            }
            if (CodeEditorGutter.isMarkDroppingDown((Context)context) && !"lightbulb".equals(columnName = (mark = CodeEditorGutter.getMarkForContext((Context)context)).getGutterColumn().getColumnName())) {
                return;
            }
            int line = CodeEditorGutter.getLineForContext((Context)context) - 1;
            LOG.trace("popping up code editor context menu at line {0}", line);
            float section = 1.0f;
            for (JMenuItem item : plugin.getMenuItemsForLine(line)) {
                if (item != null) {
                    menu.add((Component)item, section);
                    continue;
                }
                section = MenuConstants.increment((float)section);
            }
        }
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public JComponent[] gatherDynamicActions(Context context) {
        StatusEditorPlugin plugin;
        BasicEditorPane editor;
        if (Product.isRaptor()) {
            return this.noActions;
        }
        View view = context.getView();
        if (view instanceof CodeEditor && (editor = ((CodeEditor)view).getFocusedEditorPane()) != null && (plugin = (StatusEditorPlugin)editor.getProperty(KEY)) != null) {
            if (this.dynamicActions == null) {
                JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.codeAssistAction, 135.0f);
                menuItem.putClientProperty("menu-section-id", Float.valueOf(1.0f));
                this.dynamicActions = new JComponent[]{menuItem};
            }
            return this.dynamicActions;
        }
        return this.noActions;
    }

    static {
        LOG = new Log("status-editor");
        KEY = StatusEditorPlugin.AUDIT_EDITOR_PLUGIN_KEY;
    }
}

