/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.model.DirectoriesPatternFilterPanel;
import oracle.jdevimpl.model.FilesPatternFilterPanel;
import oracle.jdevimpl.model.WorkingSetsEditor;

public class PatternFiltersTreePanel
extends DefaultTraversablePanel
implements ActionListener,
GridBagConstants,
TreeWillExpandListener,
TreeCellCheckedListener {
    private final JScrollPane _spFiles = new JScrollPane();
    private final JMutableTreeNode _root = new JMutableTreeNode();
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._root, true);
    private final FileURLComparator _urlComparator = new FileURLComparator();
    protected final JButton _btnFilterFiles = new JButton();
    protected final JButton _btnFilterDirectories = new JButton();
    protected JPanel _buttonPanel;
    protected CustomJTree _dirTree;
    private KeyNavigationManager keyMgr;
    private PatternFilters _filters;
    private Project _lastProject;
    protected ContentLevelNode _rootNode;
    private transient ContentLevel _contentLevel;
    private static final String CONTENT_LEVEL = "content-level-data";
    protected String _rootNodeLabel = ModelArb.getString((int)78);

    public PatternFiltersTreePanel() {
        this.createTree();
        this._btnFilterFiles.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterFiles, (String)ModelArb.getString((int)76));
        this._btnFilterDirectories.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._btnFilterDirectories, (String)ModelArb.getString((int)77));
        this._spFiles.getViewport().add((Component)this._dirTree, null);
        this._dirTree.setRootVisible(false);
        this._dirTree.setShowsRootHandles(false);
        this._dirTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this._dirTree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._dirTree.enableToolTips(true);
        this._dirTree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 0, 5);
        Insets in0088 = new Insets(8, 3, 5, 5);
        this.add(this._spFiles, this.gbc(0, 0, 1, 1, 1.0, 1.0, 18, 1, in5555));
        this._buttonPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        this.add(this._buttonPanel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 14, 0, in0088));
        this._buttonPanel.add(this._btnFilterFiles);
        this._buttonPanel.add(this._btnFilterDirectories);
        this.setHelpID("f1_depfgpkgfilefilter_html");
    }

    public void onEntry(TraversableContext tc) {
        Project project = (Project)tc.find("Project");
        this._filters = WorkingSetsEditor.getPatternFilters((Namespace)tc);
        if (this._filters == null) {
            this._rootNode = null;
        } else {
            if (this._rootNode != null && this._rootNode.isLoaded() && project == this._lastProject) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            this._lastProject = project;
            this._rootNode = new ContentLevelNode(project);
            PatternFilters includeAllFilters = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
            includeAllFilters.addInclude("**");
            ContentSet projectContent = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            this._contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)projectContent, (PatternFilters)includeAllFilters, (boolean)false);
            ContentLevel contentLevel = (ContentLevel)tc.find(CONTENT_LEVEL);
            if (this._contentLevel != null && ModelUtil.areEqual((Object)this._contentLevel, (Object)contentLevel)) {
                this.updateCheckedStates(this._rootNode);
                return;
            }
            tc.put(CONTENT_LEVEL, (Object)this._contentLevel);
            this._root.removeAllChildren();
            this._root.add((MutableTreeNode)((Object)this._rootNode));
            this._treeModel.nodeStructureChanged((TreeNode)this._root);
            this._dirTree.setVisible(true);
            this._dirTree.setEnabled(this._filters != null);
            String[] selection = (String[])tc.find("initial-selection");
            this.initializeTreeSelection(selection);
            this.updateCheckedStates(this._rootNode);
        }
        boolean enable = false;
        if (this._filters != null && this._rootNode != null) {
            enable = true;
        }
        this._dirTree.setVisible(enable);
        this._btnFilterDirectories.setEnabled(enable);
        this._btnFilterFiles.setEnabled(enable);
    }

    public void onExit(TraversableContext tc) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath tp = e.getPath();
        ContentLevelNode node = (ContentLevelNode)((Object)tp.getLastPathComponent());
        node.maybeLoad();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, false);
    }

    private void handleCheck(TreeCellCheckedEvent e, boolean isInclude) {
        ContentLevelNode node = (ContentLevelNode)((Object)e.getSource());
        String name = node.isRootPath() ? "**" : node.getRelPath();
        if (name != null) {
            if (isInclude) {
                this._filters.addInclude(name, true);
            } else {
                this._filters.addExclude(name, true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DirectoriesPatternFilterPanel filterPanel;
        JMutableTreeNode dirNode = this.getNearestDirectory();
        String path = dirNode.isRoot() ? "" : ((ContentLevelNode)dirNode).getRelPath();
        Object source = e.getSource();
        if (source == this._btnFilterFiles) {
            FilesPatternFilterPanel filterPanel2 = new FilesPatternFilterPanel();
            if (filterPanel2.showDialog((Component)((Object)this), this._filters, path)) {
                this.updateCheckedStates(this._rootNode);
                this._dirTree.repaint();
            }
        } else if (source == this._btnFilterDirectories && (filterPanel = new DirectoriesPatternFilterPanel()).showDialog((Component)((Object)this), this._filters, path)) {
            this.updateCheckedStates(this._rootNode);
            this._dirTree.repaint();
        }
    }

    private void initializeTreeSelection(String[] selection) {
        TreePath treePath;
        if (selection != null && selection.length > 0 && (treePath = this.convertPath(selection)) != null) {
            this._dirTree.expandPath(treePath);
            this._dirTree.setSelectionPath(treePath);
            this._dirTree.scrollPathToVisible(treePath);
            return;
        }
        IdeUtil.expandTreeToDepth((JTree)this._dirTree, (int)2);
    }

    private TreePath convertPath(String[] path) {
        if (path != null && path.length > 0) {
            TreePath rootPath = new TreePath(this._root);
            TreePath root2Path = rootPath.pathByAddingChild(this._root.getChildAt(0));
            return this.findPath(root2Path, path, 0);
        }
        return null;
    }

    private TreePath findPath(TreePath treePath, String[] path, int index) {
        ContentLevelNode parent = (ContentLevelNode)((Object)treePath.getLastPathComponent());
        parent.maybeLoad();
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            ContentLevelNode child = (ContentLevelNode)((Object)parent.getChildAt(i));
            if (!child._label.equals(path[index])) continue;
            TreePath curPath = treePath.pathByAddingChild((Object)child);
            if (++index < path.length) {
                return this.findPath(curPath, path, index);
            }
            return curPath;
        }
        return null;
    }

    private void createTree() {
        this._dirTree = new CustomJTree(this._treeModel){

            protected void processKeyEvent(KeyEvent e) {
                if (PatternFiltersTreePanel.this.keyMgr != null) {
                    PatternFiltersTreePanel.this.keyMgr.preProcessKeyEvent(e);
                }
                super.processKeyEvent(e);
                if (PatternFiltersTreePanel.this.keyMgr != null) {
                    PatternFiltersTreePanel.this.keyMgr.postProcessKeyEvent(e);
                }
            }
        };
        this.keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TreeKeyAdapter((JTree)this._dirTree));
        this._dirTree.setExpandsSelectedPaths(true);
        this._dirTree.setScrollsOnExpand(true);
    }

    private void updateCheckedStates(ContentLevelNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            node.getModel().setCheckBoxState(this.isSelected(node.getRelPath()));
            return;
        }
        if (node.isLoaded()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                ContentLevelNode childNode = (ContentLevelNode)((Object)children.nextElement());
                if (childNode == null) continue;
                this.updateCheckedStates(childNode);
            }
            node.updateNodes();
        } else {
            TriStateBoolean checkBoxState = TriStateBoolean.FALSE;
            if (this._filters != null) {
                checkBoxState = this._filters.inferFromFilters(node.getRelPath());
            }
            node.getModel().setCheckBoxState(checkBoxState);
        }
    }

    private boolean isSelected(String relPath) {
        return this._filters != null ? this._filters.isIncluded(relPath) : false;
    }

    private TriStateBoolean isInitiallySelected(String relPath) {
        return this._filters != null ? this._filters.inferFromFilters(relPath) : TriStateBoolean.FALSE;
    }

    private static String getLabel(String path) {
        if (path != null) {
            if (path.endsWith("/")) {
                int dirSlash = path.lastIndexOf(47);
                if (dirSlash > 0) {
                    int lastSlash = path.lastIndexOf(47, dirSlash - 1);
                    return path.substring(lastSlash >= 0 ? lastSlash + 1 : 0, dirSlash);
                }
            } else {
                int lastSlash = path.lastIndexOf("/");
                if (lastSlash >= 0) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        return path;
    }

    private static URLPath stripRegularFiles(URLPath urlPath) {
        URLPath regularFiles = new URLPath();
        Iterator iter = urlPath.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (JarUtil.isJarURL((URL)url) || !URLFileSystem.isRegularFile((URL)url)) continue;
            iter.remove();
            regularFiles.add(url);
        }
        return regularFiles;
    }

    private static JTreeCellData newJTreeCellData(ContentLevel contentLevel, String label) {
        String urlStr;
        JTreeCellData cellData = new JTreeCellData(label);
        if (contentLevel != null && ModelUtil.hasLength((String)(urlStr = URLFileSystem.getPlatformPathName((URL)contentLevel.getDirectoryURL())))) {
            cellData.setToolTipText(urlStr);
        }
        return cellData;
    }

    private JMutableTreeNode getNearestDirectory() {
        JMutableTreeNode curNode = (JMutableTreeNode)this._dirTree.getLastSelectedPathComponent();
        if (curNode.isLeaf()) {
            return (JMutableTreeNode)curNode.getParent();
        }
        return curNode;
    }

    private static class FileURLComparator
    implements Comparator {
        private final boolean _caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();

        private FileURLComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            URL url1 = (URL)o1;
            URL url2 = (URL)o2;
            String str1 = URLFileSystem.getFileName((URL)url1);
            String str2 = URLFileSystem.getFileName((URL)url2);
            if (this._caseSensitive) {
                return str1.compareTo(str2);
            }
            return str1.compareToIgnoreCase(str2);
        }
    }

    private class ContentLevelNode
    extends JMutableTreeNode {
        private final ContentLevel _level;
        private final boolean _isLeaf;
        private final String _label;
        private final String _path;
        private boolean _isLoaded;

        ContentLevelNode(Project project) {
            this(null, String.format("%s (%s)", patternFiltersTreePanel._rootNodeLabel, project.getShortLabel()), "");
        }

        ContentLevelNode(ContentLevel level) {
            this(level, PatternFiltersTreePanel.getLabel(level.getRelPath()), level.getRelPath());
        }

        ContentLevelNode(String relPath) {
            this(null, PatternFiltersTreePanel.getLabel(relPath), relPath);
        }

        private ContentLevelNode(ContentLevel level, String label, String relPath) {
            super(PatternFiltersTreePanel.newJTreeCellData(level, label));
            this._level = level;
            this._label = label;
            this._path = relPath;
            this._isLeaf = this._level == null && !this.isRootPath();
            this._treeCellData.setIcon(this._isLeaf ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon"));
            this._treeCellData.setCheckBoxState(PatternFiltersTreePanel.this.isInitiallySelected(this.getRelPath()));
            this._treeCellData.setHasCheckBox(true);
        }

        private boolean isRootPath() {
            return "".equals(this._path);
        }

        public String getRelPath() {
            return this._path;
        }

        public boolean getAllowsChildren() {
            return !this._isLeaf;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        boolean isLoaded() {
            return this._isLoaded;
        }

        void maybeLoad() {
            if (this._isLoaded || this._level == null && !this.isRootPath()) {
                return;
            }
            final WaitCursor waitCursor = new WaitCursor((Component)((Object)PatternFiltersTreePanel.this));
            SwingWorker worker = new SwingWorker(){
                private URL[] _files;
                private String[] _folders;
                private ContentLevel contentLevel;

                public Object construct() {
                    URLPath regularFiles;
                    if (ContentLevelNode.this.isRootPath()) {
                        regularFiles = PatternFiltersTreePanel.stripRegularFiles(PatternFiltersTreePanel.this._contentLevel.getDirectoryURLPath());
                        this.contentLevel = PatternFiltersTreePanel.this._contentLevel;
                    } else {
                        regularFiles = null;
                        this.contentLevel = ContentLevelNode.this._level;
                    }
                    if (this.contentLevel != null) {
                        List children = this.contentLevel.getFiles();
                        if (regularFiles != null && regularFiles.size() > 0) {
                            List<URL> regularFilesList = Arrays.asList(regularFiles.getEntries());
                            children.addAll(regularFilesList);
                        }
                        Collections.sort(children, PatternFiltersTreePanel.this._urlComparator);
                        this._files = children.toArray(new URL[children.size()]);
                        List folders = this.contentLevel.getDirectories();
                        Collections.sort(folders);
                        this._folders = folders.toArray(new String[folders.size()]);
                    } else {
                        this._files = new URL[0];
                        this._folders = new String[0];
                    }
                    return null;
                }

                public void finished() {
                    if (this._folders.length > 0) {
                        ArrayList<String> seenPaths = new ArrayList<String>();
                        for (String folderPath : this._folders) {
                            if (seenPaths.contains(folderPath)) continue;
                            seenPaths.add(folderPath);
                            ContentLevel newLevel = this.contentLevel.getContentLevel(folderPath);
                            if (newLevel == null) continue;
                            ContentLevelNode child = new ContentLevelNode(newLevel);
                            ContentLevelNode.this.add((MutableTreeNode)((Object)child));
                        }
                        PatternFiltersTreePanel.this._treeModel.nodeStructureChanged((TreeNode)((Object)ContentLevelNode.this));
                    }
                    if (this._files.length > 0) {
                        URLPath urlPath = this.contentLevel.getDirectoryURLPath();
                        for (int i = 0; i < this._files.length; ++i) {
                            String relPath = urlPath.toShortestRelativePath(this._files[i]);
                            ContentLevelNode fileNode = new ContentLevelNode(relPath);
                            ContentLevelNode.this.add((MutableTreeNode)((Object)fileNode));
                        }
                    }
                    ContentLevelNode.this.updateNodes();
                    waitCursor.hide();
                }
            };
            waitCursor.show(400);
            this._isLoaded = true;
            worker.construct();
            worker.finished();
        }

        public String toString() {
            return this._label;
        }
    }
}

