/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLLRUCache;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheet;
import oracle.xml.xsql.XSQLStylesheetPool;
import org.xml.sax.SAXParseException;

final class XSQLStylesheetManager {
    private XSQLLRUCache stylesheetPools;
    private static XSQLStylesheetManager xcm = null;
    private static final Boolean SYNC_LOCK = Boolean.TRUE;

    public static XSQLStylesheetManager getManager() {
        if (xcm == null) {
            xcm = new XSQLStylesheetManager();
        }
        return xcm;
    }

    private XSQLStylesheetManager() {
    }

    public XSQLStylesheet getStylesheet(String string, XSQLPageRequest xSQLPageRequest, boolean bl) throws Exception, FileNotFoundException, SAXParseException, XSLException, MalformedURLException {
        XSQLStylesheetPool xSQLStylesheetPool = this.getPool(string, xSQLPageRequest, bl);
        return xSQLStylesheetPool.getStylesheet(xSQLPageRequest, bl);
    }

    public void releaseStylesheet(XSQLStylesheet xSQLStylesheet, XSQLPageRequest xSQLPageRequest, boolean bl) throws FileNotFoundException, SAXParseException, XSLException, MalformedURLException {
        try {
            XSQLStylesheetPool xSQLStylesheetPool = this.getPool(xSQLStylesheet.getUri(), xSQLPageRequest, bl);
            xSQLStylesheetPool.releaseSheet(xSQLStylesheet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSQLStylesheetPool getPool(String string, XSQLPageRequest xSQLPageRequest, boolean bl) throws FileNotFoundException, SAXParseException, XSLException, MalformedURLException {
        Object object;
        XSQLStylesheetPool xSQLStylesheetPool = null;
        String string2 = string;
        if (this.stylesheetPools == null) {
            object = SYNC_LOCK;
            synchronized (object) {
                if (this.stylesheetPools == null) {
                    XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
                    this.stylesheetPools = new XSQLLRUCache(xSQLConfigManager.getStylesheetPageCacheSize());
                }
            }
        }
        if ((xSQLStylesheetPool = (XSQLStylesheetPool)this.stylesheetPools.get(string2)) == null) {
            object = this.stylesheetPools;
            synchronized (object) {
                xSQLStylesheetPool = (XSQLStylesheetPool)this.stylesheetPools.get(string2);
                if (xSQLStylesheetPool == null && (xSQLStylesheetPool = new XSQLStylesheetPool(string, xSQLPageRequest, bl)) != null) {
                    this.stylesheetPools.put(string2, xSQLStylesheetPool);
                }
            }
        }
        return xSQLStylesheetPool;
    }
}

