/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLConnectionManagerCleanup;
import oracle.xml.xsql.XSQLConnectionManagerStatus;
import oracle.xml.xsql.XSQLConnectionPool;
import oracle.xml.xsql.XSQLNamedConnection;
import oracle.xml.xsql.XSQLNoSuchConnectionException;
import oracle.xml.xsql.XSQLPageRequest;

final class XSQLConnectionManagerImpl
implements XSQLConnectionManager,
XSQLConnectionManagerStatus,
XSQLConnectionManagerCleanup {
    private Hashtable connectionPools = new Hashtable();
    private static XSQLConnectionManagerImpl xcm = null;

    public static XSQLConnectionManager getManager() {
        if (xcm == null) {
            xcm = new XSQLConnectionManagerImpl();
        }
        return xcm;
    }

    private XSQLConnectionManagerImpl() {
    }

    @Override
    public XSQLConnection getConnection(String string, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConnectionPool xSQLConnectionPool = this.getPool(string, xSQLPageRequest);
        return xSQLConnectionPool.getConnection();
    }

    @Override
    public void releaseConnection(XSQLConnection xSQLConnection, XSQLPageRequest xSQLPageRequest) {
        try {
            this.getPool(xSQLConnection.getConnectionName(), xSQLPageRequest).releaseConnection(xSQLConnection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void showStatus(XSQLPageRequest xSQLPageRequest) {
        Object object;
        xSQLPageRequest.setContentType("text/html");
        PrintWriter printWriter = xSQLPageRequest.getWriter();
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        if (!xSQLConfigManager.dumpPoolAllowed()) {
            if (xSQLPageRequest.useHTMLErrors()) {
                if (!xSQLPageRequest.printedErrorHeader()) {
                    printWriter.println("<H1>XSQL " + xSQLPageRequest.getRequestType() + " Status</H1>");
                    xSQLPageRequest.setPrintedErrorHeader(true);
                }
            } else if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println("XSQL " + xSQLPageRequest.getRequestType() + " Status");
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
            printWriter.println("XSQL Connection Pool status dumping is disabled.");
            printWriter.flush();
            return;
        }
        if (xSQLPageRequest.useHTMLErrors()) {
            if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println("<H1>XSQL " + xSQLPageRequest.getRequestType() + " Status</H1>");
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
        } else if (!xSQLPageRequest.printedErrorHeader()) {
            printWriter.println("XSQL " + xSQLPageRequest.getRequestType() + " Status");
            xSQLPageRequest.setPrintedErrorHeader(true);
        }
        printWriter.println("Named Connections" + (xSQLPageRequest.useHTMLErrors() ? "<br>" : ""));
        Enumeration enumeration = xSQLConfigManager.getNamedConnections().keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            object = (String)enumeration.nextElement();
            printWriter.println((String)object + (xSQLPageRequest.useHTMLErrors() ? "<br>" : ""));
        }
        printWriter.println("Total of " + n + " named connections(s)." + (xSQLPageRequest.useHTMLErrors() ? "<br>" : ""));
        printWriter.println("Connection Pools" + (xSQLPageRequest.useHTMLErrors() ? "<br>" : ""));
        object = this.connectionPools.keys();
        int n2 = 0;
        while (object.hasMoreElements()) {
            ++n2;
            String string = (String)object.nextElement();
            XSQLConnectionPool xSQLConnectionPool = (XSQLConnectionPool)this.connectionPools.get(string);
            xSQLConnectionPool.dumpPool(xSQLPageRequest);
        }
        printWriter.println("Total of " + n2 + " pools.");
        printWriter.flush();
    }

    private XSQLConnectionPool getPool(String string, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        XSQLNamedConnection xSQLNamedConnection = xSQLConfigManager.getNamedConnection(xSQLPageRequest, string);
        if (xSQLNamedConnection == null) {
            xSQLPageRequest.signalError(25004, new String[]{string}, null);
            throw new XSQLNoSuchConnectionException();
        }
        return this.getPool(string, xSQLNamedConnection.getDriver(), xSQLNamedConnection.getDburl(), xSQLNamedConnection.getUsername(), xSQLNamedConnection.getPassword(), xSQLNamedConnection.getAutoCommit(), xSQLPageRequest);
    }

    private XSQLConnectionPool getPool(String string, String string2, String string3, String string4, String string5, Boolean bl, XSQLPageRequest xSQLPageRequest) throws SQLException {
        XSQLConnectionPool xSQLConnectionPool = null;
        String string6 = string;
        xSQLConnectionPool = (XSQLConnectionPool)this.connectionPools.get(string6);
        if (xSQLConnectionPool == null) {
            xSQLConnectionPool = new XSQLConnectionPool(xSQLPageRequest, string, string2, string3, string4, string5, bl);
            if (xSQLConnectionPool != null) {
                if (xSQLPageRequest.useConnectionPooling()) {
                    this.connectionPools.put(string6, xSQLConnectionPool);
                }
                return xSQLConnectionPool;
            }
            return null;
        }
        return xSQLConnectionPool;
    }

    @Override
    public synchronized void cleanup() {
        Enumeration enumeration;
        if (this.connectionPools != null && (enumeration = this.connectionPools.elements()) != null) {
            while (enumeration.hasMoreElements()) {
                XSQLConnectionPool xSQLConnectionPool = (XSQLConnectionPool)enumeration.nextElement();
                xSQLConnectionPool.cleanup();
            }
            this.connectionPools.clear();
        }
    }
}

