/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.jdevimpl.help.ColorUtils;

public class StartPageTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Color outlineColor = new Color(219, 221, 221);

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.tabInsets = new Insets(0, 0, 0, 0);
        this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
        this.tabAreaInsets = new Insets(0, 0, 0, 0);
        this.contentBorderInsets = new Insets(0, 0, 0, 0);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(outlineColor);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(outlineColor);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(outlineColor);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(outlineColor);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x - 2 + selRect.width, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isLastTab = this.tabPane.getTabCount() - 1 == tabIndex;
        g.setColor(outlineColor);
        g.drawLine(x, y + 2, x, y + h - 1);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        if (isLastTab) {
            g.drawLine(x + 2, y, x + w, y);
        } else {
            g.drawLine(x + 2, y, x + w - 3, y);
        }
        int tempw = this.tabPane.getWidth();
        if (isLastTab) {
            g.drawLine(tempw - 1, y, tempw - 1, y + h);
        } else {
            g.drawLine(x + w - 2, y, x + w - 2, y + h - 1);
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return this.calculateMaxTabWidth(tabPlacement);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        return 0;
    }

    @Override
    protected int calculateMaxTabWidth(int tabPlacement) {
        int realWidth = this.tabPane.getWidth();
        int tabCount = this.tabPane.getTabCount();
        if (tabCount == 0) {
            return 0;
        }
        return realWidth / tabCount;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return 28;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return this.calculateMaxTabHeight(tabPlacement);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isRollOver;
        Rectangle rect = this.rects[tabIndex];
        int rollOverIndex = this.getRolloverTab();
        boolean bl = isRollOver = rollOverIndex == tabIndex;
        if (isSelected) {
            ColorUtils.selectedFill.paint((Graphics2D)g, (Shape)rect);
        } else if (isRollOver) {
            ColorUtils.rolloverFill.paint((Graphics2D)g, (Shape)rect);
        } else {
            ColorUtils.normalFill.paint((Graphics2D)g, (Shape)rect);
        }
    }

    @Override
    protected void setRolloverTab(int index) {
        super.setRolloverTab(index);
        this.tabPane.repaint();
    }
}

