/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.jdeveloper.help.Cell;
import oracle.jdevimpl.help.BaseInfoComparator;
import oracle.jdevimpl.help.BrandingInfo;
import oracle.jdevimpl.help.CellInfo;
import oracle.jdevimpl.help.ColumnInfo;
import oracle.jdevimpl.help.ComponentInfo;
import oracle.jdevimpl.help.TabInfo;

public class StartPageDefinition
extends HashStructureAdapter {
    private List<ColumnInfo> _columnList;
    private List<Cell> _cellList;
    private List<Cell> _summaryCellList;
    private List<ComponentInfo> _compList;
    private BrandingInfo _brandingInfo;
    private static final String DEFAULT_HELP_ID = "ide_aonlinehelp_html";

    private StartPageDefinition(HashStructure hash) {
        super(hash);
    }

    static StartPageDefinition getInstance(HashStructure hash) {
        return new StartPageDefinition(hash);
    }

    public boolean hasTabs() {
        List hashList;
        return this._hash != null && (hashList = this._hash.getAsList("tab")) != null && hashList.size() > 0;
    }

    public List<TabInfo> getTabs() {
        List hashList;
        ArrayList<TabInfo> tabList = Collections.EMPTY_LIST;
        if (this._hash != null && (hashList = this._hash.getAsList("tab")) != null && hashList.size() > 0) {
            tabList = new ArrayList<TabInfo>(hashList.size());
            for (HashStructure h : hashList) {
                tabList.add(new TabInfo(h));
            }
            Collections.sort(tabList, new BaseInfoComparator());
        }
        return tabList;
    }

    String getHelpId() {
        if (this._hash != null) {
            HashStructure helpIdHash;
            HashStructure hashStructure = helpIdHash = this._hash.containsKey("helpId") ? this._hash.getHashStructure("helpId") : null;
            if (helpIdHash != null) {
                return helpIdHash.getString("#text", DEFAULT_HELP_ID);
            }
        }
        return DEFAULT_HELP_ID;
    }

    public List<ColumnInfo> getTopLevelColumns() {
        if (this._columnList == null) {
            List hashList;
            this._columnList = Collections.EMPTY_LIST;
            if (this._hash != null && (hashList = this._hash.getAsList("column")) != null && hashList.size() > 0) {
                this._columnList = new ArrayList<ColumnInfo>(hashList.size());
                for (HashStructure h : hashList) {
                    this._columnList.add(new ColumnInfo(h, h.getString("tab-ref")));
                }
            }
        }
        return this._columnList;
    }

    public List<Cell> getTopLevelCells(String cellType) {
        List<Cell> cellList = null;
        cellList = cellType.equals("cell") ? this._cellList : this._summaryCellList;
        if (cellList == null) {
            List hashList;
            cellList = Collections.EMPTY_LIST;
            if (this._hash != null && (hashList = this._hash.getAsList(cellType)) != null && hashList.size() > 0) {
                cellList = new ArrayList<CellInfo>(hashList.size());
                for (HashStructure h : hashList) {
                    cellList.add(new CellInfo(h));
                }
            }
            if (cellType.equals("cell")) {
                this._cellList = cellList;
            } else {
                this._summaryCellList = cellList;
            }
        }
        return cellList;
    }

    public synchronized ComponentInfo getComponentInfo(String compId) {
        List<ComponentInfo> compList = this.getComponents();
        for (ComponentInfo cInfo : compList) {
            if (!cInfo.getId().equals(compId)) continue;
            return cInfo;
        }
        return null;
    }

    private List<ComponentInfo> getComponents() {
        if (this._compList == null) {
            List hashList;
            this._compList = Collections.EMPTY_LIST;
            if (this._hash != null && (hashList = this._hash.getAsList("comp")) != null && hashList.size() > 0) {
                this._compList = new ArrayList<ComponentInfo>(hashList.size());
                for (HashStructure h : hashList) {
                    this._compList.add(new ComponentInfo(h));
                }
            }
        }
        return this._compList;
    }

    public BrandingInfo getBrandingInfo() {
        HashStructure hashStructure;
        if (this._brandingInfo == null && (hashStructure = this._hash.getHashStructure("branding")) != null) {
            this._brandingInfo = new BrandingInfo(hashStructure);
        }
        return this._brandingInfo;
    }
}

