/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xquery.exec.AbstractVisitor;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.Dot;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.PredicatedExpr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.ValidateExpr;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.XMLCons;
import oracle.xquery.exec.XMLElem;
import oracle.xquery.exec.XpathExpr;

public class ResetVisitor
extends AbstractVisitor {
    public ResetVisitor(QueryState queryState) {
        queryState.setResetTypingVisitor(this);
    }

    @Override
    protected void generalVisit(Expr expr) {
        expr.reset();
        if (expr.kids != null) {
            for (int i = 0; i < expr.kids.length; ++i) {
                expr.kids[i].acceptVisitor(this);
            }
        }
    }

    @Override
    public void visitLiteral(ConstantExpr constantExpr) {
        constantExpr.reset();
    }

    @Override
    public void visitVariableRef(VarExpr varExpr) {
        varExpr.reset();
        varExpr.var.acceptVisitor(this);
    }

    @Override
    public void visitVariable(Variable variable) {
        variable.reset();
    }

    @Override
    public void visitLetExpr(LetExpr letExpr) {
        letExpr.reset();
        letExpr.kids[0].acceptVisitor(this);
    }

    @Override
    public void visitContextItem(Dot dot) {
        dot.reset();
    }

    @Override
    public void visitFunctionCall(FunctionCall functionCall) {
        functionCall.reset();
        this.generalVisit(functionCall);
    }

    @Override
    public void visitPath(XpathExpr xpathExpr) {
        this.generalVisit(xpathExpr);
        int n = xpathExpr.steps.size();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)xpathExpr.steps.get(i);
            expr.reset();
            expr.staticType = null;
            expr.acceptVisitor(this);
        }
    }

    @Override
    public void visitPathStep(PathStep pathStep) {
        pathStep.reset();
        if (pathStep.predicateSet != null) {
            this.visitPredicateSet(pathStep.predicateSet);
        }
    }

    @Override
    public void visitPredicateExpr(PredicatedExpr predicatedExpr) {
        predicatedExpr.reset();
        predicatedExpr.kids[0].acceptVisitor(this);
        this.visitPredicateSet(predicatedExpr.predSet);
    }

    @Override
    public void visitPredicateSet(PredicateSet predicateSet) {
        predicateSet.reset();
        if (predicateSet.predicates == null) {
            return;
        }
        int n = predicateSet.predicates.size();
        for (int i = 0; i < n; ++i) {
            Predicate predicate = (Predicate)predicateSet.predicates.get(i);
            predicate.reset();
            predicate.staticType = null;
            this.visitPredicate(predicate);
        }
    }

    @Override
    public void visitPredicate(Predicate predicate) {
        predicate.reset();
        predicate.kids[0].acceptVisitor(this);
    }

    @Override
    public void visitElementConstructor(XMLElem xMLElem) {
        if (xMLElem.elemNameExpr != null) {
            xMLElem.reset();
            xMLElem.elemNameExpr.acceptVisitor(this);
        }
        this.generalVisit(xMLElem);
    }

    @Override
    public void visitOtherConstructor(XMLCons xMLCons) {
        if (xMLCons.nameExpr != null) {
            xMLCons.reset();
            xMLCons.nameExpr.acceptVisitor(this);
        }
        this.generalVisit(xMLCons);
    }

    @Override
    public void visitValidateExpr(ValidateExpr validateExpr) {
        validateExpr.reset();
        validateExpr.kids[0].acceptVisitor(this);
    }
}

