/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class GeneralComparison
extends Expr {
    int type;

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)GeneralComparison.getDoc().createElement("GenComp");
        xMLElement.setAttribute("type", XQueryUtils.typeToString(this.type, false));
        xMLElement.setAttribute("ebv", this.getEBVString());
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        this.toKidsStrRep(stringBuffer, XQueryUtils.typeToString(this.type, false));
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        int n = this.kids[0].getDatatype();
        int n2 = this.kids[1].getDatatype();
        xQXGen.startElement("function", XQXGen.createAttrs("name", XQueryUtils.typeToString(this.type, false), "infix", "true"));
        if (n == 90 && n2 == 90) {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "XMLRelop"));
            this.toSqlDefault(xQXGen);
            xQXGen.endElement("function");
            ConstantExpr.toSql(xQXGen, 0);
        } else {
            this.kids[0].toSqlScalar(xQXGen);
            this.kids[1].toSqlScalar(xQXGen);
        }
        xQXGen.endElement("function");
    }

    public void toSql_LATER(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("name", XQueryUtils.typeToString(this.type, false), "infix", "true"));
        this.toSqlDefault(xQXGen);
        xQXGen.endElement("function");
    }

    @Override
    public int getDatatype() {
        return 2;
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        this.type = XQueryUtils.typeFromString(xMLElement.getAttribute("type"));
        this.fromXMLKids(xMLElement);
        return this;
    }

    public GeneralComparison(int n, Expr expr, Expr expr2) {
        super(expr, expr2);
        this.type = n;
    }

    public GeneralComparison() {
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        if (!this.unknownEBV()) {
            OXMLItem oXMLItem = queryState.createItem();
            oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, this.trueEBV());
            OXMLSequence oXMLSequence = queryState.createSequence(oXMLItem);
            oXMLSequence.setKnownType(OXMLSequenceType.TBOOLEAN);
            return oXMLSequence;
        }
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        boolean bl = this.kids[0].needAtomization();
        if (bl) {
            oXMLSequence = oXMLSequence.atomize();
        }
        OXMLSequence oXMLSequence2 = this.kids[1].Evaluate(queryState);
        boolean bl2 = this.kids[1].needAtomization();
        if (bl2) {
            oXMLSequence2 = oXMLSequence2.atomize();
        }
        OXMLItem oXMLItem = this.compareItemLists(queryState, oXMLSequence, oXMLSequence2);
        if (bl) {
            queryState.returnSequence(oXMLSequence);
        }
        if (bl2) {
            queryState.returnSequence(oXMLSequence2);
        }
        OXMLSequence oXMLSequence3 = queryState.createSequence(oXMLItem);
        oXMLSequence3.setKnownType(OXMLSequenceType.TBOOLEAN);
        return oXMLSequence3;
    }

    private OXMLItem compareItemLists(QueryState queryState, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        OXMLItem oXMLItem;
        OXMLItem oXMLItem2 = queryState.createItem();
        if (!oXMLSequence.next() || !oXMLSequence2.next()) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, false);
            return oXMLItem2;
        }
        ArrayList<OXMLItem> arrayList = new ArrayList<OXMLItem>();
        OXMLItem oXMLItem3 = oXMLSequence.getItem();
        do {
            oXMLItem = oXMLSequence2.getItem();
            this.compareItem(queryState, oXMLItem3, oXMLItem, oXMLItem2);
            if (oXMLItem2.getBoolean()) {
                return oXMLItem2;
            }
            arrayList.add(oXMLItem);
        } while (oXMLSequence2.next());
        int n = arrayList.size();
        int n2 = 0;
        while (oXMLSequence.next()) {
            oXMLItem3 = oXMLSequence.getItem();
            for (n2 = 0; n2 < n; ++n2) {
                oXMLItem = (OXMLItem)arrayList.get(n2);
                this.compareItem(queryState, oXMLItem3, oXMLItem, oXMLItem2);
                if (!oXMLItem2.getBoolean()) continue;
                return oXMLItem2;
            }
        }
        return oXMLItem2;
    }

    private void compareItem(QueryState queryState, OXMLItem oXMLItem, OXMLItem oXMLItem2, OXMLItem oXMLItem3) {
        if (oXMLItem.matchesType(OXMLSequenceType.TUNTYPED)) {
            if (oXMLItem2.matchesType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE)) {
                OXMLItem oXMLItem4 = queryState.createItem();
                oXMLItem4.copyItem(oXMLItem);
                XQueryUtils.convert(oXMLItem4, OXMLSequenceType.TDOUBLE);
                XQueryUtils.compareValue(oXMLItem4, oXMLItem2, this.type, oXMLItem3);
            } else if (oXMLItem2.matchesType(OXMLSequenceType.TUNTYPED)) {
                OXMLItem oXMLItem5 = queryState.createItem();
                oXMLItem5.copyItem(oXMLItem);
                XQueryUtils.convert(oXMLItem5, OXMLSequenceType.TSTRING);
                OXMLItem oXMLItem6 = queryState.createItem();
                oXMLItem6.copyItem(oXMLItem2);
                XQueryUtils.convert(oXMLItem6, OXMLSequenceType.TSTRING);
                XQueryUtils.compareValue(oXMLItem5, oXMLItem6, this.type, oXMLItem3);
            } else {
                OXMLItem oXMLItem7 = queryState.createItem();
                oXMLItem7.copyItem(oXMLItem);
                XQueryUtils.convert(oXMLItem7, oXMLItem2.getItemType());
                XQueryUtils.compareValue(oXMLItem7, oXMLItem2, this.type, oXMLItem3);
            }
        } else if (oXMLItem2.matchesType(OXMLSequenceType.TUNTYPED)) {
            if (oXMLItem.matchesType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE)) {
                OXMLItem oXMLItem8 = queryState.createItem();
                oXMLItem8.copyItem(oXMLItem2);
                XQueryUtils.convert(oXMLItem8, OXMLSequenceType.TDOUBLE);
                XQueryUtils.compareValue(oXMLItem, oXMLItem8, this.type, oXMLItem3);
            } else {
                OXMLItem oXMLItem9 = queryState.createItem();
                oXMLItem9.copyItem(oXMLItem2);
                XQueryUtils.convert(oXMLItem9, oXMLItem.getItemType());
                XQueryUtils.compareValue(oXMLItem, oXMLItem9, this.type, oXMLItem3);
            }
        } else {
            XQueryUtils.compareValue(oXMLItem, oXMLItem2, this.type, oXMLItem3);
        }
    }

    @Override
    public int getPositionTest() {
        return this.getPositionTestInt(false);
    }

    private int getPositionTestInt(boolean bl) {
        if (this.kids == null || this.kids.length < 2) {
            return 0;
        }
        Expr expr = this.kids[0];
        Expr expr2 = this.kids[1];
        if (XQueryUtils.isBuiltInFunction(expr2, "position")) {
            if (expr instanceof ConstantExpr || expr instanceof FunctionCall) {
                boolean bl2;
                boolean bl3 = bl ? this.type == 210 : (bl2 = this.type == 210 || this.type == 214 || this.type == 215);
                if (bl2) {
                    return expr.getPositionTest();
                }
            }
        } else if (XQueryUtils.isBuiltInFunction(expr, "position") && (expr2 instanceof ConstantExpr || expr2 instanceof FunctionCall)) {
            boolean bl4;
            boolean bl5 = bl ? this.type == 210 : (bl4 = this.type == 210 || this.type == 212 || this.type == 213);
            if (bl4) {
                return expr2.getPositionTest();
            }
        }
        return 0;
    }

    @Override
    int getPositionTestExact() {
        return this.getPositionTestInt(true);
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitGeneralComp(this);
    }
}

