/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import oracle.xquery.XQException;

public class SymbolTable {
    private ArrayList scopes = new ArrayList();

    private HashMap currentScope() {
        if (this.scopes.isEmpty()) {
            return null;
        }
        return (HashMap)this.scopes.get(this.scopes.size() - 1);
    }

    private HashMap topScope() {
        if (this.scopes.isEmpty()) {
            return null;
        }
        return (HashMap)this.scopes.get(0);
    }

    public void BeginScope() {
        HashMap hashMap = new HashMap();
        this.scopes.add(hashMap);
    }

    public void EndScope() throws NoOpenScope {
        if (this.currentScope() == null) {
            throw new NoOpenScope();
        }
        this.scopes.remove(this.scopes.size() - 1);
    }

    public Object GetEntry(QName qName) {
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            HashMap hashMap = (HashMap)this.scopes.get(i);
            Object v = hashMap.get(qName);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Object GetEntryFromCurrentScope(QName qName) {
        HashMap hashMap = this.currentScope();
        return hashMap.get(qName);
    }

    public void AddEntry(QName qName, Object object) throws NoOpenScope {
        HashMap hashMap = this.currentScope();
        if (hashMap == null) {
            throw new NoOpenScope();
        }
        hashMap.put(qName, object);
    }

    public void AddEntryToTopScope(QName qName, Object object) throws NoOpenScope {
        HashMap hashMap = this.topScope();
        if (hashMap == null) {
            throw new NoOpenScope();
        }
        hashMap.put(qName, object);
    }

    public static class NoOpenScope
    extends XQException {
    }
}

