/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.sql.SQLException;

public class XQException
extends RuntimeException {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    int sqlErrorCode = 0;
    boolean errCodeSet = false;
    String errorTag = "error";
    String sqlState = null;
    Exception parentE = null;

    public XQException(Exception exception) {
        super(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
        this.parentE = exception;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public XQException(Exception exception, String string) {
        super(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
        this.parentE = exception;
        this.errorTag = string;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public XQException(String string, Exception exception) {
        super(string + LINE_SEPARATOR + "Detail: " + (exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage()));
        this.parentE = exception;
        if (exception instanceof SQLException) {
            this.sqlErrorCode = ((SQLException)exception).getErrorCode();
            this.sqlState = ((SQLException)exception).getSQLState();
            this.errCodeSet = true;
        }
    }

    public XQException(String string, String string2) {
        super(string + LINE_SEPARATOR + "Detail: " + string2);
    }

    public XQException(String string) {
        super(string);
    }

    public XQException() {
    }

    public String getXMLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public String getXMLSQLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append("  <MESSAGE>\n    " + this.getMessage() + "  </MESSAGE>\n");
        if (this.sqlState != null) {
            stringBuffer.append("  <SQLSTATE>" + this.sqlState + "</SQLSTATE>\n");
        }
        if (this.errCodeSet) {
            stringBuffer.append("  <ERRORCODE>" + this.sqlErrorCode + "</ERRORCODE>\n");
        }
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public Exception getParentException() {
        return this.parentE;
    }

    public void setErrorTag(String string) {
        if (string != null) {
            this.errorTag = string;
        }
    }

    public int getErrorCode() {
        return this.sqlErrorCode;
    }
}

