/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.java.source.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.model.java.source.tree.Tree;
import javax.ide.model.java.source.tree.TypeReferenceT;

public interface TypeArgumentT
extends Tree {
    public static final TypeArgumentT[] EMPTY_ARRAY = new TypeArgumentT[0];

    public BoundKind getBoundKind();

    public TypeReferenceT getType();

    public void setType(TypeReferenceT var1);

    public static final class BoundKind {
        private static final Map values = new LinkedHashMap();
        private static final int VALUE_EXACT = 0;
        private static final int VALUE_EXTENDS = 1;
        private static final int VALUE_SUPER = 2;
        private static final int VALUE_UNBOUNDED = 3;
        public static final BoundKind EXACT = new BoundKind(0, "EXACT");
        public static final BoundKind EXTENDS = new BoundKind(1, "EXTENDS");
        public static final BoundKind SUPER = new BoundKind(2, "SUPER");
        public static final BoundKind UNBOUNDED = new BoundKind(3, "UNBOUNDED");
        private final int ordinal;
        private final String name;

        private BoundKind(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
            values.put(name, this);
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }

        public int ordinal() {
            return this.ordinal;
        }

        public int hashCode() {
            return this.ordinal();
        }

        public int compareTo(BoundKind other) {
            return this.ordinal() - other.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof BoundKind) {
                BoundKind tk = (BoundKind)other;
                return this.ordinal() == tk.ordinal();
            }
            return false;
        }

        public Class getDeclaringClass() {
            return BoundKind.class;
        }

        public static BoundKind valueOf(int ordinal) {
            return BoundKind.values()[ordinal];
        }

        public static BoundKind valueOf(Class ignored, String name) {
            return (BoundKind)values.get(name);
        }

        public static BoundKind[] values() {
            Collection entries = values.values();
            return entries.toArray(new BoundKind[entries.size()]);
        }
    }
}

