/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.java.source.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ide.model.java.source.tree.BlockElementT;
import javax.ide.model.java.source.tree.ClassBodyT;
import javax.ide.model.java.source.tree.HasNameT;
import javax.ide.model.java.source.tree.InterfacesT;
import javax.ide.model.java.source.tree.MemberT;
import javax.ide.model.java.source.tree.MemberVariableT;
import javax.ide.model.java.source.tree.PackageT;
import javax.ide.model.java.source.tree.SuperclassT;
import javax.ide.model.java.source.tree.TypeReferenceT;

public interface ClassT
extends MemberT,
HasNameT,
BlockElementT {
    public static final ClassT[] EMPTY_ARRAY = new ClassT[0];

    public ClassKind getTypeKind();

    public void setTypeKind(ClassKind var1);

    public boolean isClass();

    public boolean isInterface();

    public boolean isEnum();

    public boolean isAnnotation();

    public PackageT getPackageDeclaration();

    public String getPackageName();

    public boolean isInnerClass();

    public boolean isExported();

    public boolean isAnonymous();

    public SuperclassT getSuperclassClause();

    public InterfacesT getInterfacesClause();

    public ClassBodyT getClassBody();

    public List getTypeParameters();

    public TypeReferenceT getSuperclass();

    public void setSuperclass(TypeReferenceT var1);

    public List getInterfaces();

    public List getDeclaredMembers();

    public Collection getDeclaredMemberVariables();

    public MemberVariableT getDeclaredMemberVariable(String var1);

    public List getDeclaredEnumConstants();

    public List getDeclaredFieldDeclarations();

    public Collection getDeclaredFieldVariables();

    public List getDeclaredMethods();

    public Collection getDeclaredMethods(String var1);

    public List getDeclaredConstructors();

    public List getDeclaredClasses();

    public ClassT getDeclaredClass(String var1);

    public List getDeclaredInitializers();

    public MemberT getOwningMember();

    public static final class ClassKind {
        private static final Map values = new LinkedHashMap();
        private static final int CLASS_VALUE = 0;
        private static final int INTERFACE_VALUE = 1;
        private static final int ENUM_VALUE = 2;
        private static final int ANNOTATION_VALUE = 3;
        public static final ClassKind CLASS_TYPE = new ClassKind(0, "CLASS_TYPE");
        public static final ClassKind INTERFACE_TYPE = new ClassKind(1, "INTERFACE_TYPE");
        public static final ClassKind ENUM_TYPE = new ClassKind(2, "ENUM_TYPE");
        public static final ClassKind ANNOTATION_TYPE = new ClassKind(3, "ANNOTATION_TYPE");
        private final int ordinal;
        private final String name;

        private ClassKind(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
            values.put(name, this);
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }

        public int ordinal() {
            return this.ordinal;
        }

        public int hashCode() {
            return this.ordinal();
        }

        public int compareTo(ClassKind other) {
            return this.ordinal() - other.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof ClassKind) {
                ClassKind tk = (ClassKind)other;
                return this.ordinal() == tk.ordinal();
            }
            return false;
        }

        public Class getDeclaringClass() {
            return ClassKind.class;
        }

        public static ClassKind valueOf(int ordinal) {
            return ClassKind.values()[ordinal];
        }

        public static ClassKind valueOf(Class ignored, String name) {
            return (ClassKind)values.get(name);
        }

        public static ClassKind[] values() {
            Collection entries = values.values();
            return entries.toArray(new ClassKind[entries.size()]);
        }
    }
}

