/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.java.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.model.java.declaration.AnnotationD;
import javax.ide.model.java.declaration.ArrayTypeD;
import javax.ide.model.java.declaration.ClassD;
import javax.ide.model.java.declaration.ConstructorD;
import javax.ide.model.java.declaration.FieldD;
import javax.ide.model.java.declaration.LocalVariableD;
import javax.ide.model.java.declaration.MethodD;
import javax.ide.model.java.declaration.PackageD;
import javax.ide.model.java.declaration.ParameterD;
import javax.ide.model.java.declaration.TypeVariableD;
import javax.ide.model.java.declaration.WildcardTypeD;
import javax.ide.model.java.source.SourcePosition;

public interface Declaration {
    public DeclarationKind getDeclarationKind();

    public SourcePosition getPosition();

    public boolean isSynthetic();

    public static final class DeclarationKind {
        private static final Map values = new LinkedHashMap();
        private static final int VALUE_ANNOTATION = 0;
        private static final int VALUE_ARRAY_TYPE = 1;
        private static final int VALUE_CLASS = 2;
        private static final int VALUE_CONSTRUCTOR = 3;
        private static final int VALUE_FIELD = 4;
        private static final int VALUE_LOCAL_VARIABLE = 5;
        private static final int VALUE_METHOD = 6;
        private static final int VALUE_PACKAGE = 7;
        private static final int VALUE_PARAMETER = 8;
        private static final int VALUE_TYPE_VARIABLE = 9;
        private static final int VALUE_WILDCARD_TYPE = 10;
        public static final DeclarationKind ANNOTATION = new DeclarationKind(0, "ANNOTATION", AnnotationD.class);
        public static final DeclarationKind ARRAY_TYPE = new DeclarationKind(1, "ARRAY_TYPE", ArrayTypeD.class);
        public static final DeclarationKind CLASS = new DeclarationKind(2, "CLASS", ClassD.class);
        public static final DeclarationKind CONSTRUCTOR = new DeclarationKind(3, "CONSTRUCTOR", ConstructorD.class);
        public static final DeclarationKind FIELD = new DeclarationKind(4, "FIELD", FieldD.class);
        public static final DeclarationKind LOCAL_VARIABLE = new DeclarationKind(5, "LOCAL_VARIABLE", LocalVariableD.class);
        public static final DeclarationKind METHOD = new DeclarationKind(6, "METHOD", MethodD.class);
        public static final DeclarationKind PACKAGE = new DeclarationKind(7, "PACKAGE", PackageD.class);
        public static final DeclarationKind PARAMETER = new DeclarationKind(8, "PARAMETER", ParameterD.class);
        public static final DeclarationKind TYPE_VARIABLE = new DeclarationKind(9, "TYPE_VARIABLE", TypeVariableD.class);
        public static final DeclarationKind WILDCARD_TYPE = new DeclarationKind(10, "WILDCARD_TYPE", WildcardTypeD.class);
        private final int ordinal;
        private final String name;
        private final Class exprClass;

        private DeclarationKind(int ordinal, String name, Class c) {
            this.ordinal = ordinal;
            this.name = name;
            this.exprClass = c;
            values.put(name, this);
        }

        public Class getExpressionClass() {
            return this.exprClass;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }

        public int ordinal() {
            return this.ordinal;
        }

        public int hashCode() {
            return this.ordinal();
        }

        public int compareTo(DeclarationKind other) {
            return this.ordinal() - other.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof DeclarationKind) {
                DeclarationKind tk = (DeclarationKind)other;
                return this.ordinal() == tk.ordinal();
            }
            return false;
        }

        public Class getDeclaringClass() {
            return DeclarationKind.class;
        }

        public static DeclarationKind valueOf(int ordinal) {
            return DeclarationKind.values()[ordinal];
        }

        public static DeclarationKind valueOf(Class ignored, String name) {
            return (DeclarationKind)values.get(name);
        }

        public static DeclarationKind[] values() {
            Collection entries = values.values();
            return entries.toArray(new DeclarationKind[entries.size()]);
        }
    }
}

