/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.LocationImpl;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import javax.ide.extension.spi.PullManifestParser;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;

public class MinimalExtensionParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMinimal(MinimalExtensionVisitor visitor, DefaultElementContext initialContext, Collection<ExtensionSource> extensionSources, List<ExtensionSource> failedSources) {
        PullManifestParser minimalParser = new PullManifestParser(initialContext);
        minimalParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, visitor);
        for (ExtensionSource source : extensionSources) {
            minimalParser.getContext().getScopeData().put("extSource", source);
            InputStream inputStream = null;
            try {
                inputStream = source.getInputStream();
                minimalParser.parse(inputStream, source.getManifestURI().toString());
                DefaultExtension defaultExtension = (DefaultExtension)minimalParser.getContext().getScopeData().get("extension");
            }
            catch (ParserConfigurationException pce) {
                throw new IllegalStateException("JAXP is misconfigured", pce);
            }
            catch (XMLStreamException saxe) {
                minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source: " + saxe.getLocalizedMessage(), new LocationImpl(source.getManifestURI().toString()));
                failedSources.add(source);
            }
            catch (FileNotFoundException fnf) {
                fnf.printStackTrace();
                minimalParser.getContext().getLogger().log(Level.SEVERE, source.getName() + " does not contain an extension manifest.", new LocationImpl(source.getManifestURI().toString()));
            }
            catch (IOException ioe) {
                minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source " + source.getName() + ": " + ioe.getLocalizedMessage(), new LocationImpl(source.getManifestURI().toString()));
                failedSources.add(source);
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException ioe) {
                    minimalParser.getContext().getLogger().log(Level.SEVERE, "Exception closing stream", ioe);
                }
            }
        }
    }

    private MinimalExtensionParser() {
    }
}

