/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;

public class JARExtensionSource
implements ExtensionSource {
    private static final String MANIFEST_ENTRY = "META-INF/extension.xml";
    private static final String MANIFEST_ALT_ENTRY = "meta-inf/extension.xml";
    private final URI _jarURI;
    private URI _manifestURI;

    public JARExtensionSource(URI jarURI) {
        this._jarURI = jarURI;
    }

    @Override
    public final URI getURI() {
        return this._jarURI;
    }

    @Override
    public final URI getClasspathEntry() {
        return this._jarURI;
    }

    @Override
    public URI getManifestURI() {
        if (this._manifestURI == null) {
            this._manifestURI = URIFactory.newJarURI(this._jarURI, MANIFEST_ENTRY);
            if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
                this._manifestURI = URIFactory.newJarURI(this._jarURI, MANIFEST_ALT_ENTRY);
            }
        }
        return this._manifestURI;
    }

    @Override
    public URI resolvePath(Extension extension, String path) {
        File f = new File(path);
        if (f.isAbsolute() && f.exists()) {
            return URIFactory.newFileURI(f);
        }
        if (path.length() >= 2 && path.charAt(0) == '/') {
            return URIFactory.newJarURI(this._jarURI, path.substring(1));
        }
        URI parentOfJar = VirtualFileSystem.getVirtualFileSystem().getParent(this._jarURI);
        URI parentOfJarNorm = parentOfJar.normalize();
        return URIFactory.newURI(parentOfJarNorm, path);
    }

    @Override
    public String getName() {
        return VirtualFileSystem.getVirtualFileSystem().toDisplayString(this._jarURI);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VirtualFileSystem.getVirtualFileSystem().openInputStream(this.getManifestURI());
    }

    public String toString() {
        return this.getName();
    }
}

