/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.XMLParsingUtils;
import javax.ide.net.VirtualFileSystem;
import org.xml.sax.Locator;

public final class ExtensionLogRecord
extends LogRecord {
    private LocationAdapter _location;

    public ExtensionLogRecord(LocationAdapter locationAdapter, Level level, String msg) {
        super(level, msg);
        this._location = locationAdapter.copyMe();
    }

    public ExtensionLogRecord(Locator locator, Level level, String msg) {
        super(level, msg);
        this.initLocationAdapterAndParameters(locator);
    }

    private void initLocationAdapterAndParameters(Object locator) {
        this._location = XMLParsingUtils.copyAndCastToLocationAdapter(locator);
        if (this._location != null) {
            this.setParameters(new Object[]{this._location});
        }
    }

    public ExtensionLogRecord(ElementContext context, Level level, String msg) {
        super(level, msg);
        this.initLocationAdapterAndParameters(context.getScopeData().get("xml.locator"));
    }

    public ExtensionLogRecord(Level level, String msg, Extension extension, int lineNumber) {
        super(level, msg);
        this.initLocationAdapterAndParameters(ExtensionLogRecord.extensionToLocator(extension, lineNumber));
    }

    public ExtensionLogRecord(Level level, String msg, Extension extension, int lineNumber, Throwable thrown) {
        this(level, msg, extension, lineNumber);
        this.setThrown(thrown);
    }

    private static Locator extensionToLocator(final Extension extension, final int lineNumber) {
        return new Locator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                if (extension instanceof DefaultExtension) {
                    ExtensionSource source = ((DefaultExtension)extension).getSource();
                    if (source == null) {
                        return "";
                    }
                    URI uri = source.getManifestURI();
                    if (uri != null) {
                        return VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(uri);
                    }
                }
                return "";
            }

            @Override
            public int getLineNumber() {
                return lineNumber;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }
        };
    }

    public Locator getLocator() {
        return this._location;
    }

    public LocationAdapter getLocationAdapter() {
        return this._location;
    }
}

