/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.spi.ExtensionLogRecord;

public abstract class ElementVisitor {
    public static final String KEY_LOCATOR = "xml.locator";
    private static ResourceBundleProvider s_resBundleProvider = new ResourceBundleProvider(){

        @Override
        public ResourceBundle getResourceBundle(String baseName, Locale locale, ClassLoader loader) {
            return ResourceBundle.getBundle(baseName, locale, loader);
        }
    };

    protected final void log(ElementContext context, Level level, String msg) {
        context.getLogger().log(new ExtensionLogRecord(context, level, msg));
    }

    protected final void log(ElementContext context, Level level, String msg, Object ... parameters) {
        ExtensionLogRecord record = new ExtensionLogRecord(context, level, msg);
        record.setParameters(parameters);
        context.getLogger().log(record);
    }

    public void start(ElementStartContext context) {
    }

    public void end(ElementEndContext context) {
    }

    public static final ClassLoader getClassLoader(ElementContext context) {
        ClassLoader classLoader = (ClassLoader)context.getScopeData().get("classLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static final ResourceBundle getResourceBundle(ElementContext context) {
        ClassLoader classLoader = ElementVisitor.getClassLoader(context);
        String resClass = (String)context.getScopeData().get("rsbundleclass");
        if (resClass == null) {
            return null;
        }
        try {
            return s_resBundleProvider.getResourceBundle(resClass, Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    protected String getAttributeHelper(ElementStartContext context, String attributeName, boolean trim, boolean logErrorIfMissing) {
        String value = context.getAttributeValue(attributeName);
        if (trim && value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        if (logErrorIfMissing && value == null) {
            this.log(context, Level.SEVERE, "<" + context.getElementName().getLocalName() + "> element is missing required attribute: " + attributeName);
        }
        return value;
    }

    protected String getTextHelper(ElementEndContext context, boolean trim, boolean logErrorIfMissing) {
        String value = context.getText();
        if (trim && value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        if (logErrorIfMissing && value == null) {
            this.log(context, Level.SEVERE, "<" + context.getElementName().getLocalName() + "> element is missing required text content");
        }
        return value;
    }

    public static void setResourceBundleProvider(ResourceBundleProvider resBundleProvider) {
        if (resBundleProvider != null) {
            s_resBundleProvider = resBundleProvider;
        }
    }

    public static ResourceBundleProvider getResourceBundleProvider() {
        return s_resBundleProvider;
    }

    protected ClassLoader getMetaClassLoader(ElementContext context) {
        Extension extension;
        ClassLoader classLoader = (ClassLoader)context.getScopeData().get("classLoader");
        if (classLoader == null && (extension = (Extension)context.getScopeData().get("extension")) != null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            classLoader = registry.getClassLoader(extension.getID());
        }
        return classLoader;
    }

    public static interface ResourceBundleProvider {
        public ResourceBundle getResourceBundle(String var1, Locale var2, ClassLoader var3);
    }
}

